package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrivateStrategyBuilder extends PrivateStrategyFluentImpl<PrivateStrategyBuilder> implements VisitableBuilder<PrivateStrategy,PrivateStrategyBuilder>{
  public PrivateStrategyBuilder() {
    this(false);
  }
  public PrivateStrategyBuilder(Boolean validationEnabled) {
    this(new PrivateStrategy(), validationEnabled);
  }
  public PrivateStrategyBuilder(PrivateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public PrivateStrategyBuilder(PrivateStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PrivateStrategy(), validationEnabled);
  }
  public PrivateStrategyBuilder(PrivateStrategyFluent<?> fluent,PrivateStrategy instance) {
    this(fluent, instance, false);
  }
  public PrivateStrategyBuilder(PrivateStrategyFluent<?> fluent,PrivateStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrivateStrategyBuilder(PrivateStrategy instance) {
    this(instance,false);
  }
  public PrivateStrategyBuilder(PrivateStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PrivateStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public PrivateStrategy build() {
    PrivateStrategy buildable = new PrivateStrategy();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}