package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoggingDestinationBuilder extends LoggingDestinationFluentImpl<LoggingDestinationBuilder> implements VisitableBuilder<LoggingDestination,LoggingDestinationBuilder>{
  public LoggingDestinationBuilder() {
    this(false);
  }
  public LoggingDestinationBuilder(Boolean validationEnabled) {
    this(new LoggingDestination(), validationEnabled);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoggingDestination(), validationEnabled);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance) {
    this(fluent, instance, false);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainer(instance.getContainer()); 
    fluent.withSyslog(instance.getSyslog()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LoggingDestinationBuilder(LoggingDestination instance) {
    this(instance,false);
  }
  public LoggingDestinationBuilder(LoggingDestination instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainer(instance.getContainer()); 
    this.withSyslog(instance.getSyslog()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  LoggingDestinationFluent<?> fluent;
  Boolean validationEnabled;
  public LoggingDestination build() {
    LoggingDestination buildable = new LoggingDestination(fluent.getContainer(),fluent.getSyslog(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}