package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerHTTPHeadersFluentImpl<A extends IngressControllerHTTPHeadersFluent<A>> extends BaseFluent<A> implements IngressControllerHTTPHeadersFluent<A>{
  public IngressControllerHTTPHeadersFluentImpl() {
  }
  public IngressControllerHTTPHeadersFluentImpl(IngressControllerHTTPHeaders instance) {
    this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy()); 
    this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments()); 
    this.withUniqueId(instance.getUniqueId()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String forwardedHeaderPolicy;
  private List<String> headerNameCaseAdjustments = new ArrayList<String>();
  private IngressControllerHTTPUniqueIdHeaderPolicyBuilder uniqueId;
  private Map<String,Object> additionalProperties;
  public String getForwardedHeaderPolicy() {
    return this.forwardedHeaderPolicy;
  }
  public A withForwardedHeaderPolicy(String forwardedHeaderPolicy) {
    this.forwardedHeaderPolicy=forwardedHeaderPolicy; return (A) this;
  }
  public Boolean hasForwardedHeaderPolicy() {
    return this.forwardedHeaderPolicy != null;
  }
  public A addToHeaderNameCaseAdjustments(Integer index,String item) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    this.headerNameCaseAdjustments.add(index, item);
    return (A)this;
  }
  public A setToHeaderNameCaseAdjustments(Integer index,String item) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    this.headerNameCaseAdjustments.set(index, item); return (A)this;
  }
  public A addToHeaderNameCaseAdjustments(java.lang.String... items) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    for (String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
  }
  public A addAllToHeaderNameCaseAdjustments(Collection<String> items) {
    if (this.headerNameCaseAdjustments == null) {this.headerNameCaseAdjustments = new ArrayList<String>();}
    for (String item : items) {this.headerNameCaseAdjustments.add(item);} return (A)this;
  }
  public A removeFromHeaderNameCaseAdjustments(java.lang.String... items) {
    for (String item : items) {if (this.headerNameCaseAdjustments!= null){ this.headerNameCaseAdjustments.remove(item);}} return (A)this;
  }
  public A removeAllFromHeaderNameCaseAdjustments(Collection<String> items) {
    for (String item : items) {if (this.headerNameCaseAdjustments!= null){ this.headerNameCaseAdjustments.remove(item);}} return (A)this;
  }
  public List<String> getHeaderNameCaseAdjustments() {
    return this.headerNameCaseAdjustments;
  }
  public String getHeaderNameCaseAdjustment(Integer index) {
    return this.headerNameCaseAdjustments.get(index);
  }
  public String getFirstHeaderNameCaseAdjustment() {
    return this.headerNameCaseAdjustments.get(0);
  }
  public String getLastHeaderNameCaseAdjustment() {
    return this.headerNameCaseAdjustments.get(headerNameCaseAdjustments.size() - 1);
  }
  public String getMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
    for (String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
    for (String item: headerNameCaseAdjustments) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeaderNameCaseAdjustments(List<String> headerNameCaseAdjustments) {
    if (headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments = new ArrayList(); for (String item : headerNameCaseAdjustments){this.addToHeaderNameCaseAdjustments(item);}} else { this.headerNameCaseAdjustments = null;} return (A) this;
  }
  public A withHeaderNameCaseAdjustments(java.lang.String... headerNameCaseAdjustments) {
    if (this.headerNameCaseAdjustments != null) {this.headerNameCaseAdjustments.clear();}
    if (headerNameCaseAdjustments != null) {for (String item :headerNameCaseAdjustments){ this.addToHeaderNameCaseAdjustments(item);}} return (A) this;
  }
  public Boolean hasHeaderNameCaseAdjustments() {
    return headerNameCaseAdjustments != null && !headerNameCaseAdjustments.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildUniqueId instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressControllerHTTPUniqueIdHeaderPolicy getUniqueId() {
    return this.uniqueId!=null ?this.uniqueId.build():null;
  }
  public IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId() {
    return this.uniqueId!=null ?this.uniqueId.build():null;
  }
  public A withUniqueId(IngressControllerHTTPUniqueIdHeaderPolicy uniqueId) {
    _visitables.get("uniqueId").remove(this.uniqueId);
    if (uniqueId!=null){ this.uniqueId= new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(uniqueId); _visitables.get("uniqueId").add(this.uniqueId);} else { this.uniqueId = null; _visitables.get("uniqueId").remove(this.uniqueId); } return (A) this;
  }
  public Boolean hasUniqueId() {
    return this.uniqueId != null;
  }
  public A withNewUniqueId(String format,String name) {
    return (A)withUniqueId(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueId() {
    return new IngressControllerHTTPHeadersFluentImpl.UniqueIdNestedImpl();
  }
  public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new IngressControllerHTTPHeadersFluentImpl.UniqueIdNestedImpl(item);
  }
  public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editUniqueId() {
    return withNewUniqueIdLike(getUniqueId());
  }
  public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueId() {
    return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): new IngressControllerHTTPUniqueIdHeaderPolicyBuilder().build());
  }
  public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return withNewUniqueIdLike(getUniqueId() != null ? getUniqueId(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressControllerHTTPHeadersFluentImpl that = (IngressControllerHTTPHeadersFluentImpl) o;
    if (forwardedHeaderPolicy != null ? !forwardedHeaderPolicy.equals(that.forwardedHeaderPolicy) :that.forwardedHeaderPolicy != null) return false;
    if (headerNameCaseAdjustments != null ? !headerNameCaseAdjustments.equals(that.headerNameCaseAdjustments) :that.headerNameCaseAdjustments != null) return false;
    if (uniqueId != null ? !uniqueId.equals(that.uniqueId) :that.uniqueId != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(forwardedHeaderPolicy,  headerNameCaseAdjustments,  uniqueId,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forwardedHeaderPolicy != null) { sb.append("forwardedHeaderPolicy:"); sb.append(forwardedHeaderPolicy + ","); }
    if (headerNameCaseAdjustments != null && !headerNameCaseAdjustments.isEmpty()) { sb.append("headerNameCaseAdjustments:"); sb.append(headerNameCaseAdjustments + ","); }
    if (uniqueId != null) { sb.append("uniqueId:"); sb.append(uniqueId + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class UniqueIdNestedImpl<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<IngressControllerHTTPHeadersFluent.UniqueIdNested<N>> implements IngressControllerHTTPHeadersFluent.UniqueIdNested<N>,Nested<N>{
    UniqueIdNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    UniqueIdNestedImpl() {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerHTTPHeadersFluentImpl.this.withUniqueId(builder.build());
    }
    public N endUniqueId() {
      return and();
    }
    
  }
  
}