package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerCaptureHTTPHeaderBuilder extends IngressControllerCaptureHTTPHeaderFluentImpl<IngressControllerCaptureHTTPHeaderBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPHeader,IngressControllerCaptureHTTPHeaderBuilder>{
  public IngressControllerCaptureHTTPHeaderBuilder() {
    this(false);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(Boolean validationEnabled) {
    this(new IngressControllerCaptureHTTPHeader(), validationEnabled);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerCaptureHTTPHeader(), validationEnabled);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,IngressControllerCaptureHTTPHeader instance) {
    this(fluent, instance, false);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeaderFluent<?> fluent,IngressControllerCaptureHTTPHeader instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxLength(instance.getMaxLength()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeader instance) {
    this(instance,false);
  }
  public IngressControllerCaptureHTTPHeaderBuilder(IngressControllerCaptureHTTPHeader instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxLength(instance.getMaxLength()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressControllerCaptureHTTPHeaderFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerCaptureHTTPHeader build() {
    IngressControllerCaptureHTTPHeader buildable = new IngressControllerCaptureHTTPHeader(fluent.getMaxLength(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}