package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleStatusBuilder extends ConsoleStatusFluentImpl<ConsoleStatusBuilder> implements VisitableBuilder<ConsoleStatus,ConsoleStatusBuilder>{
  public ConsoleStatusBuilder() {
    this(false);
  }
  public ConsoleStatusBuilder(Boolean validationEnabled) {
    this(new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance) {
    this(fluent, instance, false);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withGenerations(instance.getGenerations()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleStatusBuilder(ConsoleStatus instance) {
    this(instance,false);
  }
  public ConsoleStatusBuilder(ConsoleStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withGenerations(instance.getGenerations()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleStatus build() {
    ConsoleStatus buildable = new ConsoleStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}