package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.config.v1.ConfigMapFileReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConsoleCustomizationFluentImpl<A extends ConsoleCustomizationFluent<A>> extends BaseFluent<A> implements ConsoleCustomizationFluent<A>{
  public ConsoleCustomizationFluentImpl() {
  }
  public ConsoleCustomizationFluentImpl(ConsoleCustomization instance) {
    this.withAddPage(instance.getAddPage()); 
    this.withBrand(instance.getBrand()); 
    this.withCustomLogoFile(instance.getCustomLogoFile()); 
    this.withCustomProductName(instance.getCustomProductName()); 
    this.withDeveloperCatalog(instance.getDeveloperCatalog()); 
    this.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
    this.withProjectAccess(instance.getProjectAccess()); 
    this.withQuickStarts(instance.getQuickStarts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private AddPageBuilder addPage;
  private String brand;
  private ConfigMapFileReference customLogoFile;
  private String customProductName;
  private DeveloperConsoleCatalogCustomizationBuilder developerCatalog;
  private String documentationBaseURL;
  private ProjectAccessBuilder projectAccess;
  private QuickStartsBuilder quickStarts;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAddPage instead.
   * @return The buildable object.
   */
  @Deprecated
  public AddPage getAddPage() {
    return this.addPage!=null ?this.addPage.build():null;
  }
  public AddPage buildAddPage() {
    return this.addPage!=null ?this.addPage.build():null;
  }
  public A withAddPage(AddPage addPage) {
    _visitables.get("addPage").remove(this.addPage);
    if (addPage!=null){ this.addPage= new AddPageBuilder(addPage); _visitables.get("addPage").add(this.addPage);} else { this.addPage = null; _visitables.get("addPage").remove(this.addPage); } return (A) this;
  }
  public Boolean hasAddPage() {
    return this.addPage != null;
  }
  public ConsoleCustomizationFluent.AddPageNested<A> withNewAddPage() {
    return new ConsoleCustomizationFluentImpl.AddPageNestedImpl();
  }
  public ConsoleCustomizationFluent.AddPageNested<A> withNewAddPageLike(AddPage item) {
    return new ConsoleCustomizationFluentImpl.AddPageNestedImpl(item);
  }
  public ConsoleCustomizationFluent.AddPageNested<A> editAddPage() {
    return withNewAddPageLike(getAddPage());
  }
  public ConsoleCustomizationFluent.AddPageNested<A> editOrNewAddPage() {
    return withNewAddPageLike(getAddPage() != null ? getAddPage(): new AddPageBuilder().build());
  }
  public ConsoleCustomizationFluent.AddPageNested<A> editOrNewAddPageLike(AddPage item) {
    return withNewAddPageLike(getAddPage() != null ? getAddPage(): item);
  }
  public String getBrand() {
    return this.brand;
  }
  public A withBrand(String brand) {
    this.brand=brand; return (A) this;
  }
  public Boolean hasBrand() {
    return this.brand != null;
  }
  public ConfigMapFileReference getCustomLogoFile() {
    return this.customLogoFile;
  }
  public A withCustomLogoFile(ConfigMapFileReference customLogoFile) {
    this.customLogoFile=customLogoFile; return (A) this;
  }
  public Boolean hasCustomLogoFile() {
    return this.customLogoFile != null;
  }
  public A withNewCustomLogoFile(String key,String name) {
    return (A)withCustomLogoFile(new ConfigMapFileReference(key, name));
  }
  public String getCustomProductName() {
    return this.customProductName;
  }
  public A withCustomProductName(String customProductName) {
    this.customProductName=customProductName; return (A) this;
  }
  public Boolean hasCustomProductName() {
    return this.customProductName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDeveloperCatalog instead.
   * @return The buildable object.
   */
  @Deprecated
  public DeveloperConsoleCatalogCustomization getDeveloperCatalog() {
    return this.developerCatalog!=null ?this.developerCatalog.build():null;
  }
  public DeveloperConsoleCatalogCustomization buildDeveloperCatalog() {
    return this.developerCatalog!=null ?this.developerCatalog.build():null;
  }
  public A withDeveloperCatalog(DeveloperConsoleCatalogCustomization developerCatalog) {
    _visitables.get("developerCatalog").remove(this.developerCatalog);
    if (developerCatalog!=null){ this.developerCatalog= new DeveloperConsoleCatalogCustomizationBuilder(developerCatalog); _visitables.get("developerCatalog").add(this.developerCatalog);} else { this.developerCatalog = null; _visitables.get("developerCatalog").remove(this.developerCatalog); } return (A) this;
  }
  public Boolean hasDeveloperCatalog() {
    return this.developerCatalog != null;
  }
  public ConsoleCustomizationFluent.DeveloperCatalogNested<A> withNewDeveloperCatalog() {
    return new ConsoleCustomizationFluentImpl.DeveloperCatalogNestedImpl();
  }
  public ConsoleCustomizationFluent.DeveloperCatalogNested<A> withNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
    return new ConsoleCustomizationFluentImpl.DeveloperCatalogNestedImpl(item);
  }
  public ConsoleCustomizationFluent.DeveloperCatalogNested<A> editDeveloperCatalog() {
    return withNewDeveloperCatalogLike(getDeveloperCatalog());
  }
  public ConsoleCustomizationFluent.DeveloperCatalogNested<A> editOrNewDeveloperCatalog() {
    return withNewDeveloperCatalogLike(getDeveloperCatalog() != null ? getDeveloperCatalog(): new DeveloperConsoleCatalogCustomizationBuilder().build());
  }
  public ConsoleCustomizationFluent.DeveloperCatalogNested<A> editOrNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
    return withNewDeveloperCatalogLike(getDeveloperCatalog() != null ? getDeveloperCatalog(): item);
  }
  public String getDocumentationBaseURL() {
    return this.documentationBaseURL;
  }
  public A withDocumentationBaseURL(String documentationBaseURL) {
    this.documentationBaseURL=documentationBaseURL; return (A) this;
  }
  public Boolean hasDocumentationBaseURL() {
    return this.documentationBaseURL != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProjectAccess instead.
   * @return The buildable object.
   */
  @Deprecated
  public ProjectAccess getProjectAccess() {
    return this.projectAccess!=null ?this.projectAccess.build():null;
  }
  public ProjectAccess buildProjectAccess() {
    return this.projectAccess!=null ?this.projectAccess.build():null;
  }
  public A withProjectAccess(ProjectAccess projectAccess) {
    _visitables.get("projectAccess").remove(this.projectAccess);
    if (projectAccess!=null){ this.projectAccess= new ProjectAccessBuilder(projectAccess); _visitables.get("projectAccess").add(this.projectAccess);} else { this.projectAccess = null; _visitables.get("projectAccess").remove(this.projectAccess); } return (A) this;
  }
  public Boolean hasProjectAccess() {
    return this.projectAccess != null;
  }
  public ConsoleCustomizationFluent.ProjectAccessNested<A> withNewProjectAccess() {
    return new ConsoleCustomizationFluentImpl.ProjectAccessNestedImpl();
  }
  public ConsoleCustomizationFluent.ProjectAccessNested<A> withNewProjectAccessLike(ProjectAccess item) {
    return new ConsoleCustomizationFluentImpl.ProjectAccessNestedImpl(item);
  }
  public ConsoleCustomizationFluent.ProjectAccessNested<A> editProjectAccess() {
    return withNewProjectAccessLike(getProjectAccess());
  }
  public ConsoleCustomizationFluent.ProjectAccessNested<A> editOrNewProjectAccess() {
    return withNewProjectAccessLike(getProjectAccess() != null ? getProjectAccess(): new ProjectAccessBuilder().build());
  }
  public ConsoleCustomizationFluent.ProjectAccessNested<A> editOrNewProjectAccessLike(ProjectAccess item) {
    return withNewProjectAccessLike(getProjectAccess() != null ? getProjectAccess(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuickStarts instead.
   * @return The buildable object.
   */
  @Deprecated
  public QuickStarts getQuickStarts() {
    return this.quickStarts!=null ?this.quickStarts.build():null;
  }
  public QuickStarts buildQuickStarts() {
    return this.quickStarts!=null ?this.quickStarts.build():null;
  }
  public A withQuickStarts(QuickStarts quickStarts) {
    _visitables.get("quickStarts").remove(this.quickStarts);
    if (quickStarts!=null){ this.quickStarts= new QuickStartsBuilder(quickStarts); _visitables.get("quickStarts").add(this.quickStarts);} else { this.quickStarts = null; _visitables.get("quickStarts").remove(this.quickStarts); } return (A) this;
  }
  public Boolean hasQuickStarts() {
    return this.quickStarts != null;
  }
  public ConsoleCustomizationFluent.QuickStartsNested<A> withNewQuickStarts() {
    return new ConsoleCustomizationFluentImpl.QuickStartsNestedImpl();
  }
  public ConsoleCustomizationFluent.QuickStartsNested<A> withNewQuickStartsLike(QuickStarts item) {
    return new ConsoleCustomizationFluentImpl.QuickStartsNestedImpl(item);
  }
  public ConsoleCustomizationFluent.QuickStartsNested<A> editQuickStarts() {
    return withNewQuickStartsLike(getQuickStarts());
  }
  public ConsoleCustomizationFluent.QuickStartsNested<A> editOrNewQuickStarts() {
    return withNewQuickStartsLike(getQuickStarts() != null ? getQuickStarts(): new QuickStartsBuilder().build());
  }
  public ConsoleCustomizationFluent.QuickStartsNested<A> editOrNewQuickStartsLike(QuickStarts item) {
    return withNewQuickStartsLike(getQuickStarts() != null ? getQuickStarts(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsoleCustomizationFluentImpl that = (ConsoleCustomizationFluentImpl) o;
    if (addPage != null ? !addPage.equals(that.addPage) :that.addPage != null) return false;
    if (brand != null ? !brand.equals(that.brand) :that.brand != null) return false;
    if (customLogoFile != null ? !customLogoFile.equals(that.customLogoFile) :that.customLogoFile != null) return false;
    if (customProductName != null ? !customProductName.equals(that.customProductName) :that.customProductName != null) return false;
    if (developerCatalog != null ? !developerCatalog.equals(that.developerCatalog) :that.developerCatalog != null) return false;
    if (documentationBaseURL != null ? !documentationBaseURL.equals(that.documentationBaseURL) :that.documentationBaseURL != null) return false;
    if (projectAccess != null ? !projectAccess.equals(that.projectAccess) :that.projectAccess != null) return false;
    if (quickStarts != null ? !quickStarts.equals(that.quickStarts) :that.quickStarts != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addPage,  brand,  customLogoFile,  customProductName,  developerCatalog,  documentationBaseURL,  projectAccess,  quickStarts,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addPage != null) { sb.append("addPage:"); sb.append(addPage + ","); }
    if (brand != null) { sb.append("brand:"); sb.append(brand + ","); }
    if (customLogoFile != null) { sb.append("customLogoFile:"); sb.append(customLogoFile + ","); }
    if (customProductName != null) { sb.append("customProductName:"); sb.append(customProductName + ","); }
    if (developerCatalog != null) { sb.append("developerCatalog:"); sb.append(developerCatalog + ","); }
    if (documentationBaseURL != null) { sb.append("documentationBaseURL:"); sb.append(documentationBaseURL + ","); }
    if (projectAccess != null) { sb.append("projectAccess:"); sb.append(projectAccess + ","); }
    if (quickStarts != null) { sb.append("quickStarts:"); sb.append(quickStarts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AddPageNestedImpl<N> extends AddPageFluentImpl<ConsoleCustomizationFluent.AddPageNested<N>> implements ConsoleCustomizationFluent.AddPageNested<N>,Nested<N>{
    AddPageNestedImpl(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageNestedImpl() {
      this.builder = new AddPageBuilder(this);
    }
    AddPageBuilder builder;
    public N and() {
      return (N) ConsoleCustomizationFluentImpl.this.withAddPage(builder.build());
    }
    public N endAddPage() {
      return and();
    }
    
  }
  class DeveloperCatalogNestedImpl<N> extends DeveloperConsoleCatalogCustomizationFluentImpl<ConsoleCustomizationFluent.DeveloperCatalogNested<N>> implements ConsoleCustomizationFluent.DeveloperCatalogNested<N>,Nested<N>{
    DeveloperCatalogNestedImpl(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperCatalogNestedImpl() {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    public N and() {
      return (N) ConsoleCustomizationFluentImpl.this.withDeveloperCatalog(builder.build());
    }
    public N endDeveloperCatalog() {
      return and();
    }
    
  }
  class ProjectAccessNestedImpl<N> extends ProjectAccessFluentImpl<ConsoleCustomizationFluent.ProjectAccessNested<N>> implements ConsoleCustomizationFluent.ProjectAccessNested<N>,Nested<N>{
    ProjectAccessNestedImpl(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessNestedImpl() {
      this.builder = new ProjectAccessBuilder(this);
    }
    ProjectAccessBuilder builder;
    public N and() {
      return (N) ConsoleCustomizationFluentImpl.this.withProjectAccess(builder.build());
    }
    public N endProjectAccess() {
      return and();
    }
    
  }
  class QuickStartsNestedImpl<N> extends QuickStartsFluentImpl<ConsoleCustomizationFluent.QuickStartsNested<N>> implements ConsoleCustomizationFluent.QuickStartsNested<N>,Nested<N>{
    QuickStartsNestedImpl(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsNestedImpl() {
      this.builder = new QuickStartsBuilder(this);
    }
    QuickStartsBuilder builder;
    public N and() {
      return (N) ConsoleCustomizationFluentImpl.this.withQuickStarts(builder.build());
    }
    public N endQuickStarts() {
      return and();
    }
    
  }
  
}