package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigSpecBuilder extends ConfigSpecFluentImpl<ConfigSpecBuilder> implements VisitableBuilder<ConfigSpec,ConfigSpecBuilder>{
  public ConfigSpecBuilder() {
    this(false);
  }
  public ConfigSpecBuilder(Boolean validationEnabled) {
    this(new ConfigSpec(), validationEnabled);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigSpec(), validationEnabled);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,ConfigSpec instance) {
    this(fluent, instance, false);
  }
  public ConfigSpecBuilder(ConfigSpecFluent<?> fluent,ConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigSpecBuilder(ConfigSpec instance) {
    this(instance,false);
  }
  public ConfigSpecBuilder(ConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigSpec build() {
    ConfigSpec buildable = new ConfigSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}