package io.fabric8.openshift.api.model.operator.controlplane.v1alpha1;

import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodNetworkConnectivityCheckSpecFluentImpl<A extends PodNetworkConnectivityCheckSpecFluent<A>> extends BaseFluent<A> implements PodNetworkConnectivityCheckSpecFluent<A>{
  public PodNetworkConnectivityCheckSpecFluentImpl() {
  }
  public PodNetworkConnectivityCheckSpecFluentImpl(PodNetworkConnectivityCheckSpec instance) {
    this.withSourcePod(instance.getSourcePod()); 
    this.withTargetEndpoint(instance.getTargetEndpoint()); 
    this.withTlsClientCert(instance.getTlsClientCert()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String sourcePod;
  private String targetEndpoint;
  private SecretNameReference tlsClientCert;
  private Map<String,Object> additionalProperties;
  public String getSourcePod() {
    return this.sourcePod;
  }
  public A withSourcePod(String sourcePod) {
    this.sourcePod=sourcePod; return (A) this;
  }
  public Boolean hasSourcePod() {
    return this.sourcePod != null;
  }
  public String getTargetEndpoint() {
    return this.targetEndpoint;
  }
  public A withTargetEndpoint(String targetEndpoint) {
    this.targetEndpoint=targetEndpoint; return (A) this;
  }
  public Boolean hasTargetEndpoint() {
    return this.targetEndpoint != null;
  }
  public SecretNameReference getTlsClientCert() {
    return this.tlsClientCert;
  }
  public A withTlsClientCert(SecretNameReference tlsClientCert) {
    this.tlsClientCert=tlsClientCert; return (A) this;
  }
  public Boolean hasTlsClientCert() {
    return this.tlsClientCert != null;
  }
  public A withNewTlsClientCert(String name) {
    return (A)withTlsClientCert(new SecretNameReference(name));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodNetworkConnectivityCheckSpecFluentImpl that = (PodNetworkConnectivityCheckSpecFluentImpl) o;
    if (sourcePod != null ? !sourcePod.equals(that.sourcePod) :that.sourcePod != null) return false;
    if (targetEndpoint != null ? !targetEndpoint.equals(that.targetEndpoint) :that.targetEndpoint != null) return false;
    if (tlsClientCert != null ? !tlsClientCert.equals(that.tlsClientCert) :that.tlsClientCert != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(sourcePod,  targetEndpoint,  tlsClientCert,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sourcePod != null) { sb.append("sourcePod:"); sb.append(sourcePod + ","); }
    if (targetEndpoint != null) { sb.append("targetEndpoint:"); sb.append(targetEndpoint + ","); }
    if (tlsClientCert != null) { sb.append("tlsClientCert:"); sb.append(tlsClientCert + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}