package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceCatalogControllerManagerBuilder extends ServiceCatalogControllerManagerFluent<ServiceCatalogControllerManagerBuilder> implements VisitableBuilder<ServiceCatalogControllerManager,ServiceCatalogControllerManagerBuilder>{
  public ServiceCatalogControllerManagerBuilder() {
    this(new ServiceCatalogControllerManager());
  }
  
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent) {
    this(fluent, new ServiceCatalogControllerManager());
  }
  
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,ServiceCatalogControllerManager instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManager instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceCatalogControllerManagerFluent<?> fluent;
  
  public ServiceCatalogControllerManager build() {
    ServiceCatalogControllerManager buildable = new ServiceCatalogControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}