package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KuryrConfigBuilder extends KuryrConfigFluent<KuryrConfigBuilder> implements VisitableBuilder<KuryrConfig,KuryrConfigBuilder>{
  public KuryrConfigBuilder() {
    this(new KuryrConfig());
  }
  
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent) {
    this(fluent, new KuryrConfig());
  }
  
  public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,KuryrConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KuryrConfigBuilder(KuryrConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KuryrConfigFluent<?> fluent;
  
  public KuryrConfig build() {
    KuryrConfig buildable = new KuryrConfig(fluent.getControllerProbesPort(),fluent.getDaemonProbesPort(),fluent.getEnablePortPoolsPrepopulation(),fluent.getMtu(),fluent.getOpenStackServiceNetwork(),fluent.getPoolBatchPorts(),fluent.getPoolMaxPorts(),fluent.getPoolMinPorts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}