package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClientTLSBuilder extends ClientTLSFluent<ClientTLSBuilder> implements VisitableBuilder<ClientTLS,ClientTLSBuilder>{
  public ClientTLSBuilder() {
    this(new ClientTLS());
  }
  
  public ClientTLSBuilder(ClientTLSFluent<?> fluent) {
    this(fluent, new ClientTLS());
  }
  
  public ClientTLSBuilder(ClientTLSFluent<?> fluent,ClientTLS instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClientTLSBuilder(ClientTLS instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClientTLSFluent<?> fluent;
  
  public ClientTLS build() {
    ClientTLS buildable = new ClientTLS(fluent.getAllowedSubjectPatterns(),fluent.getClientCA(),fluent.getClientCertificatePolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}