/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ConfigResourceCondition;
import io.fabric8.openshift.api.model.monitoring.v1.ConfigResourceConditionBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ConfigResourceConditionFluent;
import io.fabric8.openshift.api.model.monitoring.v1.WorkloadBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class WorkloadBindingFluent<A extends WorkloadBindingFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<ConfigResourceConditionBuilder> conditions = new ArrayList();
    private String group;
    private String name;
    private String namespace;
    private String resource;

    public WorkloadBindingFluent() {
    }

    public WorkloadBindingFluent(WorkloadBinding instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<ConfigResourceCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ConfigResourceCondition item : items) {
            ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(ConfigResourceCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ConfigResourceCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ConfigResourceCondition item : items) {
            ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, ConfigResourceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ConfigResourceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<ConfigResourceCondition> buildConditions() {
        return this.conditions != null ? WorkloadBindingFluent.build(this.conditions) : null;
    }

    public ConfigResourceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ConfigResourceCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ConfigResourceCondition buildMatchingCondition(Predicate<ConfigResourceConditionBuilder> predicate) {
        for (ConfigResourceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(WorkloadBinding instance) {
        WorkloadBinding workloadBinding = instance = instance != null ? instance : new WorkloadBinding();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withGroup(instance.getGroup());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResource(instance.getResource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConfigResourceConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkloadBindingFluent that = (WorkloadBindingFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public boolean hasMatchingCondition(Predicate<ConfigResourceConditionBuilder> predicate) {
        for (ConfigResourceConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.group, this.name, this.namespace, this.resource, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<ConfigResourceCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ConfigResourceCondition item : items) {
            ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ConfigResourceCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ConfigResourceCondition item : items) {
            ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConfigResourceConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigResourceConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConfigResourceConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ConfigResourceCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, ConfigResourceCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConfigResourceConditionBuilder builder = new ConfigResourceConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConditions(List<ConfigResourceCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ConfigResourceCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ConfigResourceCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ConfigResourceCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends ConfigResourceConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConfigResourceConditionBuilder builder;
        int index;

        ConditionsNested(int index, ConfigResourceCondition item) {
            this.index = index;
            this.builder = new ConfigResourceConditionBuilder(this, item);
        }

        public N and() {
            return (N)WorkloadBindingFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

