/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetStaticConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProbeTargetStaticConfigFluent<A extends ProbeTargetStaticConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> _static = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    private Map<String, String> labels;
    private ArrayList<RelabelConfigBuilder> relabelingConfigs = new ArrayList();

    public ProbeTargetStaticConfigFluent() {
    }

    public ProbeTargetStaticConfigFluent(ProbeTargetStaticConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStatic(Collection<String> items) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        for (String item : items) {
            this._static.add(item);
        }
        return (A)((Object)this);
    }

    public RelabelingConfigsNested<A> addNewRelabelingConfig() {
        return new RelabelingConfigsNested(-1, null);
    }

    public RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
        return new RelabelingConfigsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRelabelingConfigs(RelabelConfig ... items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRelabelingConfigs(int index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelingConfigs.size()) {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        } else {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStatic(String ... items) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        for (String item : items) {
            this._static.add(item);
        }
        return (A)((Object)this);
    }

    public A addToStatic(int index, String item) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        this._static.add(index, item);
        return (A)((Object)this);
    }

    public RelabelConfig buildFirstRelabelingConfig() {
        return this.relabelingConfigs.get(0).build();
    }

    public RelabelConfig buildLastRelabelingConfig() {
        return this.relabelingConfigs.get(this.relabelingConfigs.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public RelabelConfig buildRelabelingConfig(int index) {
        return this.relabelingConfigs.get(index).build();
    }

    public List<RelabelConfig> buildRelabelingConfigs() {
        return this.relabelingConfigs != null ? ProbeTargetStaticConfigFluent.build(this.relabelingConfigs) : null;
    }

    protected void copyInstance(ProbeTargetStaticConfig instance) {
        ProbeTargetStaticConfig probeTargetStaticConfig = instance = instance != null ? instance : new ProbeTargetStaticConfig();
        if (instance != null) {
            this.withLabels(instance.getLabels());
            this.withRelabelingConfigs(instance.getRelabelingConfigs());
            this.withStatic(instance.getStatic());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RelabelingConfigsNested<A> editFirstRelabelingConfig() {
        if (this.relabelingConfigs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(0, this.buildRelabelingConfig(0));
    }

    public RelabelingConfigsNested<A> editLastRelabelingConfig() {
        int index = this.relabelingConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelingConfigs.size(); ++i) {
            if (!predicate.test(this.relabelingConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public RelabelingConfigsNested<A> editRelabelingConfig(int index) {
        if (this.relabelingConfigs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeTargetStaticConfigFluent that = (ProbeTargetStaticConfigFluent)((Object)o);
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.relabelingConfigs, that.relabelingConfigs)) {
            return false;
        }
        if (!Objects.equals(this._static, that._static)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstStatic() {
        return this._static.get(0);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getLastStatic() {
        return this._static.get(this._static.size() - 1);
    }

    public String getMatchingStatic(Predicate<String> predicate) {
        for (String item : this._static) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public List<String> getStatic() {
        return this._static;
    }

    public String getStatic(int index) {
        return this._static.get(index);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingStatic(Predicate<String> predicate) {
        for (String item : this._static) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelabelingConfigs() {
        return this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty();
    }

    public boolean hasStatic() {
        return this._static != null && !this._static.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.relabelingConfigs, this._static, this.additionalProperties);
    }

    public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove((Object)builder);
            this.relabelingConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStatic(Collection<String> items) {
        if (this._static == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this._static.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRelabelingConfigs(RelabelConfig ... items) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove((Object)builder);
            this.relabelingConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStatic(String ... items) {
        if (this._static == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this._static.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.relabelingConfigs.iterator();
        List visitables = this._visitables.get((Object)"relabelingConfigs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RelabelingConfigsNested<A> setNewRelabelingConfigLike(int index, RelabelConfig item) {
        return new RelabelingConfigsNested(index, item);
    }

    public A setToRelabelingConfigs(int index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelingConfigs.size()) {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        } else {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStatic(int index, String item) {
        if (this._static == null) {
            this._static = new ArrayList<String>();
        }
        this._static.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels);
            sb.append(",");
        }
        if (this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty()) {
            sb.append("relabelingConfigs:");
            sb.append(this.relabelingConfigs);
            sb.append(",");
        }
        if (this._static != null && !this._static.isEmpty()) {
            sb.append("_static:");
            sb.append(this._static);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this._visitables.get((Object)"relabelingConfigs").clear();
        }
        if (relabelingConfigs != null) {
            this.relabelingConfigs = new ArrayList();
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        } else {
            this.relabelingConfigs = null;
        }
        return (A)((Object)this);
    }

    public A withRelabelingConfigs(RelabelConfig ... relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this.relabelingConfigs.clear();
            this._visitables.remove((Object)"relabelingConfigs");
        }
        if (relabelingConfigs != null) {
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withStatic(List<String> _static) {
        if (_static != null) {
            this._static = new ArrayList<String>();
            for (String item : _static) {
                this.addToStatic(item);
            }
        } else {
            this._static = null;
        }
        return (A)((Object)this);
    }

    public A withStatic(String ... _static) {
        if (this._static != null) {
            this._static.clear();
            this._visitables.remove((Object)"_static");
        }
        if (_static != null) {
            for (String item : _static) {
                this.addToStatic(item);
            }
        }
        return (A)((Object)this);
    }

    public class RelabelingConfigsNested<N>
    extends RelabelConfigFluent<RelabelingConfigsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        RelabelingConfigsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)ProbeTargetStaticConfigFluent.this.setToRelabelingConfigs(this.index, this.builder.build());
        }

        public N endRelabelingConfig() {
            return this.and();
        }
    }
}

