/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AlertingRuleSpec;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroup;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroupBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlertingRuleSpecFluent<A extends AlertingRuleSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<RuleGroupBuilder> groups = new ArrayList();

    public AlertingRuleSpecFluent() {
    }

    public AlertingRuleSpecFluent(AlertingRuleSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToGroups(Collection<RuleGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (RuleGroup item : items) {
            RuleGroupBuilder builder = new RuleGroupBuilder(item);
            this._visitables.get((Object)"groups").add(builder);
            this.groups.add(builder);
        }
        return (A)((Object)this);
    }

    public GroupsNested<A> addNewGroup() {
        return new GroupsNested(-1, null);
    }

    public GroupsNested<A> addNewGroupLike(RuleGroup item) {
        return new GroupsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToGroups(RuleGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (RuleGroup item : items) {
            RuleGroupBuilder builder = new RuleGroupBuilder(item);
            this._visitables.get((Object)"groups").add(builder);
            this.groups.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToGroups(int index, RuleGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        RuleGroupBuilder builder = new RuleGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get((Object)"groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get((Object)"groups").add(builder);
            this.groups.add(index, builder);
        }
        return (A)((Object)this);
    }

    public RuleGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    public RuleGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    public List<RuleGroup> buildGroups() {
        return this.groups != null ? AlertingRuleSpecFluent.build(this.groups) : null;
    }

    public RuleGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    public RuleGroup buildMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        for (RuleGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(AlertingRuleSpec instance) {
        AlertingRuleSpec alertingRuleSpec = instance = instance != null ? instance : new AlertingRuleSpec();
        if (instance != null) {
            this.withGroups(instance.getGroups());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "groups"));
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    public GroupsNested<A> editGroup(int index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "groups"));
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "groups"));
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.test(this.groups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "groups"));
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertingRuleSpecFluent that = (AlertingRuleSpecFluent)((Object)o);
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public boolean hasMatchingGroup(Predicate<RuleGroupBuilder> predicate) {
        for (RuleGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.additionalProperties);
    }

    public A removeAllFromGroups(Collection<RuleGroup> items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (RuleGroup item : items) {
            RuleGroupBuilder builder = new RuleGroupBuilder(item);
            this._visitables.get((Object)"groups").remove((Object)builder);
            this.groups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromGroups(RuleGroup ... items) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        for (RuleGroup item : items) {
            RuleGroupBuilder builder = new RuleGroupBuilder(item);
            this._visitables.get((Object)"groups").remove((Object)builder);
            this.groups.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGroups(Predicate<RuleGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)((Object)this);
        }
        Iterator<RuleGroupBuilder> each = this.groups.iterator();
        List visitables = this._visitables.get((Object)"groups");
        while (each.hasNext()) {
            RuleGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public GroupsNested<A> setNewGroupLike(int index, RuleGroup item) {
        return new GroupsNested(index, item);
    }

    public A setToGroups(int index, RuleGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        RuleGroupBuilder builder = new RuleGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get((Object)"groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get((Object)"groups").add(builder);
            this.groups.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withGroups(List<RuleGroup> groups) {
        if (this.groups != null) {
            this._visitables.get((Object)"groups").clear();
        }
        if (groups != null) {
            this.groups = new ArrayList();
            for (RuleGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)((Object)this);
    }

    public A withGroups(RuleGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove((Object)"groups");
        }
        if (groups != null) {
            for (RuleGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)((Object)this);
    }

    public class GroupsNested<N>
    extends RuleGroupFluent<GroupsNested<N>>
    implements Nested<N> {
        RuleGroupBuilder builder;
        int index;

        GroupsNested(int index, RuleGroup item) {
            this.index = index;
            this.builder = new RuleGroupBuilder(this, item);
        }

        public N and() {
            return (N)AlertingRuleSpecFluent.this.setToGroups(this.index, this.builder.build());
        }

        public N endGroup() {
            return this.and();
        }
    }
}

