package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
public class PrometheusTracingConfigBuilder extends PrometheusTracingConfigFluent<PrometheusTracingConfigBuilder> implements VisitableBuilder<PrometheusTracingConfig,PrometheusTracingConfigBuilder>{

  PrometheusTracingConfigFluent<?> fluent;

  public PrometheusTracingConfigBuilder() {
    this(new PrometheusTracingConfig());
  }
  
  public PrometheusTracingConfigBuilder(PrometheusTracingConfigFluent<?> fluent) {
    this(fluent, new PrometheusTracingConfig());
  }
  
  public PrometheusTracingConfigBuilder(PrometheusTracingConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  
  public PrometheusTracingConfigBuilder(PrometheusTracingConfigFluent<?> fluent,PrometheusTracingConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }

  public PrometheusTracingConfig build() {
    PrometheusTracingConfig buildable = new PrometheusTracingConfig(fluent.getClientType(), fluent.getCompression(), fluent.getEndpoint(), fluent.getHeaders(), fluent.getInsecure(), fluent.getSamplingFraction(), fluent.getTimeout(), fluent.buildTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}