/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimeInterval;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimePeriod;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimePeriodBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimePeriodFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TimeIntervalFluent<A extends TimeIntervalFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String name;
    private ArrayList<TimePeriodBuilder> timeIntervals = new ArrayList();

    public TimeIntervalFluent() {
    }

    public TimeIntervalFluent(TimeInterval instance) {
        this.copyInstance(instance);
    }

    public A addAllToTimeIntervals(Collection<TimePeriod> items) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        for (TimePeriod item : items) {
            TimePeriodBuilder builder = new TimePeriodBuilder(item);
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        }
        return (A)((Object)this);
    }

    public TimeIntervalsNested<A> addNewTimeInterval() {
        return new TimeIntervalsNested(-1, null);
    }

    public TimeIntervalsNested<A> addNewTimeIntervalLike(TimePeriod item) {
        return new TimeIntervalsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTimeIntervals(TimePeriod ... items) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        for (TimePeriod item : items) {
            TimePeriodBuilder builder = new TimePeriodBuilder(item);
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToTimeIntervals(int index, TimePeriod item) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        TimePeriodBuilder builder = new TimePeriodBuilder(item);
        if (index < 0 || index >= this.timeIntervals.size()) {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        } else {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(index, builder);
        }
        return (A)((Object)this);
    }

    public TimePeriod buildFirstTimeInterval() {
        return this.timeIntervals.get(0).build();
    }

    public TimePeriod buildLastTimeInterval() {
        return this.timeIntervals.get(this.timeIntervals.size() - 1).build();
    }

    public TimePeriod buildMatchingTimeInterval(Predicate<TimePeriodBuilder> predicate) {
        for (TimePeriodBuilder item : this.timeIntervals) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public TimePeriod buildTimeInterval(int index) {
        return this.timeIntervals.get(index).build();
    }

    public List<TimePeriod> buildTimeIntervals() {
        return this.timeIntervals != null ? TimeIntervalFluent.build(this.timeIntervals) : null;
    }

    protected void copyInstance(TimeInterval instance) {
        TimeInterval timeInterval = instance = instance != null ? instance : new TimeInterval();
        if (instance != null) {
            this.withName(instance.getName());
            this.withTimeIntervals(instance.getTimeIntervals());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public TimeIntervalsNested<A> editFirstTimeInterval() {
        if (this.timeIntervals.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "timeIntervals"));
        }
        return this.setNewTimeIntervalLike(0, this.buildTimeInterval(0));
    }

    public TimeIntervalsNested<A> editLastTimeInterval() {
        int index = this.timeIntervals.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "timeIntervals"));
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public TimeIntervalsNested<A> editMatchingTimeInterval(Predicate<TimePeriodBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.timeIntervals.size(); ++i) {
            if (!predicate.test(this.timeIntervals.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "timeIntervals"));
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public TimeIntervalsNested<A> editTimeInterval(int index) {
        if (this.timeIntervals.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "timeIntervals"));
        }
        return this.setNewTimeIntervalLike(index, this.buildTimeInterval(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimeIntervalFluent that = (TimeIntervalFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.timeIntervals, that.timeIntervals)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingTimeInterval(Predicate<TimePeriodBuilder> predicate) {
        for (TimePeriodBuilder item : this.timeIntervals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasTimeIntervals() {
        return this.timeIntervals != null && !this.timeIntervals.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.timeIntervals, this.additionalProperties);
    }

    public A removeAllFromTimeIntervals(Collection<TimePeriod> items) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        for (TimePeriod item : items) {
            TimePeriodBuilder builder = new TimePeriodBuilder(item);
            this._visitables.get((Object)"timeIntervals").remove((Object)builder);
            this.timeIntervals.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTimeIntervals(TimePeriod ... items) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        for (TimePeriod item : items) {
            TimePeriodBuilder builder = new TimePeriodBuilder(item);
            this._visitables.get((Object)"timeIntervals").remove((Object)builder);
            this.timeIntervals.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTimeIntervals(Predicate<TimePeriodBuilder> predicate) {
        if (this.timeIntervals == null) {
            return (A)((Object)this);
        }
        Iterator<TimePeriodBuilder> each = this.timeIntervals.iterator();
        List visitables = this._visitables.get((Object)"timeIntervals");
        while (each.hasNext()) {
            TimePeriodBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public TimeIntervalsNested<A> setNewTimeIntervalLike(int index, TimePeriod item) {
        return new TimeIntervalsNested(index, item);
    }

    public A setToTimeIntervals(int index, TimePeriod item) {
        if (this.timeIntervals == null) {
            this.timeIntervals = new ArrayList();
        }
        TimePeriodBuilder builder = new TimePeriodBuilder(item);
        if (index < 0 || index >= this.timeIntervals.size()) {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.add(builder);
        } else {
            this._visitables.get((Object)"timeIntervals").add(builder);
            this.timeIntervals.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.timeIntervals != null && !this.timeIntervals.isEmpty()) {
            sb.append("timeIntervals:");
            sb.append(this.timeIntervals);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public A withTimeIntervals(List<TimePeriod> timeIntervals) {
        if (this.timeIntervals != null) {
            this._visitables.get((Object)"timeIntervals").clear();
        }
        if (timeIntervals != null) {
            this.timeIntervals = new ArrayList();
            for (TimePeriod item : timeIntervals) {
                this.addToTimeIntervals(item);
            }
        } else {
            this.timeIntervals = null;
        }
        return (A)((Object)this);
    }

    public A withTimeIntervals(TimePeriod ... timeIntervals) {
        if (this.timeIntervals != null) {
            this.timeIntervals.clear();
            this._visitables.remove((Object)"timeIntervals");
        }
        if (timeIntervals != null) {
            for (TimePeriod item : timeIntervals) {
                this.addToTimeIntervals(item);
            }
        }
        return (A)((Object)this);
    }

    public class TimeIntervalsNested<N>
    extends TimePeriodFluent<TimeIntervalsNested<N>>
    implements Nested<N> {
        TimePeriodBuilder builder;
        int index;

        TimeIntervalsNested(int index, TimePeriod item) {
            this.index = index;
            this.builder = new TimePeriodBuilder(this, item);
        }

        public N and() {
            return (N)TimeIntervalFluent.this.setToTimeIntervals(this.index, this.builder.build());
        }

        public N endTimeInterval() {
            return this.and();
        }
    }
}

