/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Rules;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlert;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlertBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RulesFluent<A extends RulesFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private RulesAlertBuilder alert;

    public RulesFluent() {
    }

    public RulesFluent(Rules instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public RulesAlert buildAlert() {
        return this.alert != null ? this.alert.build() : null;
    }

    protected void copyInstance(Rules instance) {
        Rules rules = instance = instance != null ? instance : new Rules();
        if (instance != null) {
            this.withAlert(instance.getAlert());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AlertNested<A> editAlert() {
        return this.withNewAlertLike(Optional.ofNullable(this.buildAlert()).orElse(null));
    }

    public AlertNested<A> editOrNewAlert() {
        return this.withNewAlertLike(Optional.ofNullable(this.buildAlert()).orElse(new RulesAlertBuilder().build()));
    }

    public AlertNested<A> editOrNewAlertLike(RulesAlert item) {
        return this.withNewAlertLike(Optional.ofNullable(this.buildAlert()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RulesFluent that = (RulesFluent)((Object)o);
        if (!Objects.equals((Object)this.alert, (Object)that.alert)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAlert() {
        return this.alert != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alert, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alert != null) {
            sb.append("alert:");
            sb.append((Object)this.alert);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAlert(RulesAlert alert) {
        this._visitables.remove((Object)"alert");
        if (alert != null) {
            this.alert = new RulesAlertBuilder(alert);
            this._visitables.get((Object)"alert").add(this.alert);
        } else {
            this.alert = null;
            this._visitables.get((Object)"alert").remove((Object)this.alert);
        }
        return (A)((Object)this);
    }

    public AlertNested<A> withNewAlert() {
        return new AlertNested(null);
    }

    public A withNewAlert(String forGracePeriod, String forOutageTolerance, String resendDelay) {
        return this.withAlert(new RulesAlert(forGracePeriod, forOutageTolerance, resendDelay));
    }

    public AlertNested<A> withNewAlertLike(RulesAlert item) {
        return new AlertNested(item);
    }

    public class AlertNested<N>
    extends RulesAlertFluent<AlertNested<N>>
    implements Nested<N> {
        RulesAlertBuilder builder;

        AlertNested(RulesAlert item) {
            this.builder = new RulesAlertBuilder(this, item);
        }

        public N and() {
            return (N)RulesFluent.this.withAlert(this.builder.build());
        }

        public N endAlert() {
            return this.and();
        }
    }
}

