/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ProbeTargetIngressFluent<A extends ProbeTargetIngressFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private NamespaceSelectorBuilder namespaceSelector;
    private ArrayList<RelabelConfigBuilder> relabelingConfigs = new ArrayList();
    private LabelSelectorBuilder selector;

    public ProbeTargetIngressFluent() {
    }

    public ProbeTargetIngressFluent(ProbeTargetIngress instance) {
        this.copyInstance(instance);
    }

    public A addAllToRelabelingConfigs(Collection<RelabelConfig> items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public RelabelingConfigsNested<A> addNewRelabelingConfig() {
        return new RelabelingConfigsNested(-1, null);
    }

    public RelabelingConfigsNested<A> addNewRelabelingConfigLike(RelabelConfig item) {
        return new RelabelingConfigsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRelabelingConfigs(RelabelConfig ... items) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToRelabelingConfigs(int index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelingConfigs.size()) {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        } else {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public RelabelConfig buildFirstRelabelingConfig() {
        return this.relabelingConfigs.get(0).build();
    }

    public RelabelConfig buildLastRelabelingConfig() {
        return this.relabelingConfigs.get(this.relabelingConfigs.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public RelabelConfig buildRelabelingConfig(int index) {
        return this.relabelingConfigs.get(index).build();
    }

    public List<RelabelConfig> buildRelabelingConfigs() {
        return this.relabelingConfigs != null ? ProbeTargetIngressFluent.build(this.relabelingConfigs) : null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    protected void copyInstance(ProbeTargetIngress instance) {
        ProbeTargetIngress probeTargetIngress = instance = instance != null ? instance : new ProbeTargetIngress();
        if (instance != null) {
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withRelabelingConfigs(instance.getRelabelingConfigs());
            this.withSelector(instance.getSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RelabelingConfigsNested<A> editFirstRelabelingConfig() {
        if (this.relabelingConfigs.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(0, this.buildRelabelingConfig(0));
    }

    public RelabelingConfigsNested<A> editLastRelabelingConfig() {
        int index = this.relabelingConfigs.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public RelabelingConfigsNested<A> editMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelingConfigs.size(); ++i) {
            if (!predicate.test(this.relabelingConfigs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public RelabelingConfigsNested<A> editRelabelingConfig(int index) {
        if (this.relabelingConfigs.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "relabelingConfigs"));
        }
        return this.setNewRelabelingConfigLike(index, this.buildRelabelingConfig(index));
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeTargetIngressFluent that = (ProbeTargetIngressFluent)((Object)o);
        if (!Objects.equals((Object)this.namespaceSelector, (Object)that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.relabelingConfigs, that.relabelingConfigs)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingRelabelingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelingConfigs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public boolean hasRelabelingConfigs() {
        return this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty();
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespaceSelector, this.relabelingConfigs, this.selector, this.additionalProperties});
    }

    public A removeAllFromRelabelingConfigs(Collection<RelabelConfig> items) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove((Object)builder);
            this.relabelingConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRelabelingConfigs(RelabelConfig ... items) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelingConfigs").remove((Object)builder);
            this.relabelingConfigs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelabelingConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelingConfigs == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.relabelingConfigs.iterator();
        List visitables = this._visitables.get((Object)"relabelingConfigs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public RelabelingConfigsNested<A> setNewRelabelingConfigLike(int index, RelabelConfig item) {
        return new RelabelingConfigsNested(index, item);
    }

    public A setToRelabelingConfigs(int index, RelabelConfig item) {
        if (this.relabelingConfigs == null) {
            this.relabelingConfigs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelingConfigs.size()) {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.add(builder);
        } else {
            this._visitables.get((Object)"relabelingConfigs").add(builder);
            this.relabelingConfigs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append((Object)this.namespaceSelector);
            sb.append(",");
        }
        if (this.relabelingConfigs != null && !this.relabelingConfigs.isEmpty()) {
            sb.append("relabelingConfigs:");
            sb.append(this.relabelingConfigs);
            sb.append(",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove((Object)this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public A withRelabelingConfigs(List<RelabelConfig> relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this._visitables.get((Object)"relabelingConfigs").clear();
        }
        if (relabelingConfigs != null) {
            this.relabelingConfigs = new ArrayList();
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        } else {
            this.relabelingConfigs = null;
        }
        return (A)((Object)this);
    }

    public A withRelabelingConfigs(RelabelConfig ... relabelingConfigs) {
        if (this.relabelingConfigs != null) {
            this.relabelingConfigs.clear();
            this._visitables.remove((Object)"relabelingConfigs");
        }
        if (relabelingConfigs != null) {
            for (RelabelConfig item : relabelingConfigs) {
                this.addToRelabelingConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ProbeTargetIngressFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class RelabelingConfigsNested<N>
    extends RelabelConfigFluent<RelabelingConfigsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        RelabelingConfigsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)ProbeTargetIngressFluent.this.setToRelabelingConfigs(this.index, this.builder.build());
        }

        public N endRelabelingConfig() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends NamespaceSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        NamespaceSelectorBuilder builder;

        NamespaceSelectorNested(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ProbeTargetIngressFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }
}

