/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.TelegramConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TelegramConfigFluent<A extends TelegramConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiURL;
    private SecretKeySelector botToken;
    private String botTokenFile;
    private Long chatID;
    private Boolean disableNotifications;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private Long messageThreadID;
    private String parseMode;
    private Boolean sendResolved;

    public TelegramConfigFluent() {
    }

    public TelegramConfigFluent(TelegramConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    protected void copyInstance(TelegramConfig instance) {
        TelegramConfig telegramConfig = instance = instance != null ? instance : new TelegramConfig();
        if (instance != null) {
            this.withApiURL(instance.getApiURL());
            this.withBotToken(instance.getBotToken());
            this.withBotTokenFile(instance.getBotTokenFile());
            this.withChatID(instance.getChatID());
            this.withDisableNotifications(instance.getDisableNotifications());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withMessageThreadID(instance.getMessageThreadID());
            this.withParseMode(instance.getParseMode());
            this.withSendResolved(instance.getSendResolved());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TelegramConfigFluent that = (TelegramConfigFluent)((Object)o);
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.botToken, that.botToken)) {
            return false;
        }
        if (!Objects.equals(this.botTokenFile, that.botTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.chatID, that.chatID)) {
            return false;
        }
        if (!Objects.equals(this.disableNotifications, that.disableNotifications)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.messageThreadID, that.messageThreadID)) {
            return false;
        }
        if (!Objects.equals(this.parseMode, that.parseMode)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public SecretKeySelector getBotToken() {
        return this.botToken;
    }

    public String getBotTokenFile() {
        return this.botTokenFile;
    }

    public Long getChatID() {
        return this.chatID;
    }

    public Boolean getDisableNotifications() {
        return this.disableNotifications;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getMessageThreadID() {
        return this.messageThreadID;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public boolean hasBotToken() {
        return this.botToken != null;
    }

    public boolean hasBotTokenFile() {
        return this.botTokenFile != null;
    }

    public boolean hasChatID() {
        return this.chatID != null;
    }

    public boolean hasDisableNotifications() {
        return this.disableNotifications != null;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasMessageThreadID() {
        return this.messageThreadID != null;
    }

    public boolean hasParseMode() {
        return this.parseMode != null;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiURL, this.botToken, this.botTokenFile, this.chatID, this.disableNotifications, this.httpConfig, this.message, this.messageThreadID, this.parseMode, this.sendResolved, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL);
            sb.append(",");
        }
        if (this.botToken != null) {
            sb.append("botToken:");
            sb.append(this.botToken);
            sb.append(",");
        }
        if (this.botTokenFile != null) {
            sb.append("botTokenFile:");
            sb.append(this.botTokenFile);
            sb.append(",");
        }
        if (this.chatID != null) {
            sb.append("chatID:");
            sb.append(this.chatID);
            sb.append(",");
        }
        if (this.disableNotifications != null) {
            sb.append("disableNotifications:");
            sb.append(this.disableNotifications);
            sb.append(",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append((Object)this.httpConfig);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.messageThreadID != null) {
            sb.append("messageThreadID:");
            sb.append(this.messageThreadID);
            sb.append(",");
        }
        if (this.parseMode != null) {
            sb.append("parseMode:");
            sb.append(this.parseMode);
            sb.append(",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)((Object)this);
    }

    public A withBotToken(SecretKeySelector botToken) {
        this.botToken = botToken;
        return (A)((Object)this);
    }

    public A withBotTokenFile(String botTokenFile) {
        this.botTokenFile = botTokenFile;
        return (A)((Object)this);
    }

    public A withChatID(Long chatID) {
        this.chatID = chatID;
        return (A)((Object)this);
    }

    public A withDisableNotifications() {
        return this.withDisableNotifications(true);
    }

    public A withDisableNotifications(Boolean disableNotifications) {
        this.disableNotifications = disableNotifications;
        return (A)((Object)this);
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public A withMessageThreadID(Long messageThreadID) {
        this.messageThreadID = messageThreadID;
        return (A)((Object)this);
    }

    public A withNewBotToken(String key, String name, Boolean optional) {
        return this.withBotToken(new SecretKeySelector(key, name, optional));
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public A withParseMode(String parseMode) {
        this.parseMode = parseMode;
        return (A)((Object)this);
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)TelegramConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

