/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.PushoverConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushoverConfigFluent<A extends PushoverConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String device;
    private String expire;
    private Boolean html;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String priority;
    private String retry;
    private Boolean sendResolved;
    private String sound;
    private String title;
    private SecretKeySelector token;
    private String tokenFile;
    private String ttl;
    private String url;
    private String urlTitle;
    private SecretKeySelector userKey;
    private String userKeyFile;

    public PushoverConfigFluent() {
    }

    public PushoverConfigFluent(PushoverConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    protected void copyInstance(PushoverConfig instance) {
        PushoverConfig pushoverConfig = instance = instance != null ? instance : new PushoverConfig();
        if (instance != null) {
            this.withDevice(instance.getDevice());
            this.withExpire(instance.getExpire());
            this.withHtml(instance.getHtml());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withPriority(instance.getPriority());
            this.withRetry(instance.getRetry());
            this.withSendResolved(instance.getSendResolved());
            this.withSound(instance.getSound());
            this.withTitle(instance.getTitle());
            this.withToken(instance.getToken());
            this.withTokenFile(instance.getTokenFile());
            this.withTtl(instance.getTtl());
            this.withUrl(instance.getUrl());
            this.withUrlTitle(instance.getUrlTitle());
            this.withUserKey(instance.getUserKey());
            this.withUserKeyFile(instance.getUserKeyFile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PushoverConfigFluent that = (PushoverConfigFluent)((Object)o);
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.expire, that.expire)) {
            return false;
        }
        if (!Objects.equals(this.html, that.html)) {
            return false;
        }
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.retry, that.retry)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.sound, that.sound)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.tokenFile, that.tokenFile)) {
            return false;
        }
        if (!Objects.equals(this.ttl, that.ttl)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.urlTitle, that.urlTitle)) {
            return false;
        }
        if (!Objects.equals(this.userKey, that.userKey)) {
            return false;
        }
        if (!Objects.equals(this.userKeyFile, that.userKeyFile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDevice() {
        return this.device;
    }

    public String getExpire() {
        return this.expire;
    }

    public Boolean getHtml() {
        return this.html;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getRetry() {
        return this.retry;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public String getSound() {
        return this.sound;
    }

    public String getTitle() {
        return this.title;
    }

    public SecretKeySelector getToken() {
        return this.token;
    }

    public String getTokenFile() {
        return this.tokenFile;
    }

    public String getTtl() {
        return this.ttl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlTitle() {
        return this.urlTitle;
    }

    public SecretKeySelector getUserKey() {
        return this.userKey;
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public boolean hasExpire() {
        return this.expire != null;
    }

    public boolean hasHtml() {
        return this.html != null;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public boolean hasSound() {
        return this.sound != null;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public boolean hasTokenFile() {
        return this.tokenFile != null;
    }

    public boolean hasTtl() {
        return this.ttl != null;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean hasUrlTitle() {
        return this.urlTitle != null;
    }

    public boolean hasUserKey() {
        return this.userKey != null;
    }

    public boolean hasUserKeyFile() {
        return this.userKeyFile != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.device, this.expire, this.html, this.httpConfig, this.message, this.priority, this.retry, this.sendResolved, this.sound, this.title, this.token, this.tokenFile, this.ttl, this.url, this.urlTitle, this.userKey, this.userKeyFile, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device);
            sb.append(",");
        }
        if (this.expire != null) {
            sb.append("expire:");
            sb.append(this.expire);
            sb.append(",");
        }
        if (this.html != null) {
            sb.append("html:");
            sb.append(this.html);
            sb.append(",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append((Object)this.httpConfig);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority);
            sb.append(",");
        }
        if (this.retry != null) {
            sb.append("retry:");
            sb.append(this.retry);
            sb.append(",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved);
            sb.append(",");
        }
        if (this.sound != null) {
            sb.append("sound:");
            sb.append(this.sound);
            sb.append(",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title);
            sb.append(",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token);
            sb.append(",");
        }
        if (this.tokenFile != null) {
            sb.append("tokenFile:");
            sb.append(this.tokenFile);
            sb.append(",");
        }
        if (this.ttl != null) {
            sb.append("ttl:");
            sb.append(this.ttl);
            sb.append(",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
            sb.append(",");
        }
        if (this.urlTitle != null) {
            sb.append("urlTitle:");
            sb.append(this.urlTitle);
            sb.append(",");
        }
        if (this.userKey != null) {
            sb.append("userKey:");
            sb.append(this.userKey);
            sb.append(",");
        }
        if (this.userKeyFile != null) {
            sb.append("userKeyFile:");
            sb.append(this.userKeyFile);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)((Object)this);
    }

    public A withExpire(String expire) {
        this.expire = expire;
        return (A)((Object)this);
    }

    public A withHtml() {
        return this.withHtml(true);
    }

    public A withHtml(Boolean html) {
        this.html = html;
        return (A)((Object)this);
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)((Object)this);
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public A withNewToken(String key, String name, Boolean optional) {
        return this.withToken(new SecretKeySelector(key, name, optional));
    }

    public A withNewUserKey(String key, String name, Boolean optional) {
        return this.withUserKey(new SecretKeySelector(key, name, optional));
    }

    public A withPriority(String priority) {
        this.priority = priority;
        return (A)((Object)this);
    }

    public A withRetry(String retry) {
        this.retry = retry;
        return (A)((Object)this);
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public A withSound(String sound) {
        this.sound = sound;
        return (A)((Object)this);
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public A withToken(SecretKeySelector token) {
        this.token = token;
        return (A)((Object)this);
    }

    public A withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return (A)((Object)this);
    }

    public A withTtl(String ttl) {
        this.ttl = ttl;
        return (A)((Object)this);
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public A withUrlTitle(String urlTitle) {
        this.urlTitle = urlTitle;
        return (A)((Object)this);
    }

    public A withUserKey(SecretKeySelector userKey) {
        this.userKey = userKey;
        return (A)((Object)this);
    }

    public A withUserKeyFile(String userKeyFile) {
        this.userKeyFile = userKeyFile;
        return (A)((Object)this);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)PushoverConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

