/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.MSTeamsConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MSTeamsConfigFluent<A extends MSTeamsConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private HTTPConfigBuilder httpConfig;
    private Boolean sendResolved;
    private String summary;
    private String text;
    private String title;
    private SecretKeySelector webhookUrl;

    public MSTeamsConfigFluent() {
    }

    public MSTeamsConfigFluent(MSTeamsConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    protected void copyInstance(MSTeamsConfig instance) {
        MSTeamsConfig mSTeamsConfig = instance = instance != null ? instance : new MSTeamsConfig();
        if (instance != null) {
            this.withHttpConfig(instance.getHttpConfig());
            this.withSendResolved(instance.getSendResolved());
            this.withSummary(instance.getSummary());
            this.withText(instance.getText());
            this.withTitle(instance.getTitle());
            this.withWebhookUrl(instance.getWebhookUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MSTeamsConfigFluent that = (MSTeamsConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.httpConfig, (Object)that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.summary, that.summary)) {
            return false;
        }
        if (!Objects.equals(this.text, that.text)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        if (!Objects.equals(this.webhookUrl, that.webhookUrl)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public SecretKeySelector getWebhookUrl() {
        return this.webhookUrl;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public boolean hasSummary() {
        return this.summary != null;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public boolean hasWebhookUrl() {
        return this.webhookUrl != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.httpConfig, this.sendResolved, this.summary, this.text, this.title, this.webhookUrl, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append((Object)this.httpConfig);
            sb.append(",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved);
            sb.append(",");
        }
        if (this.summary != null) {
            sb.append("summary:");
            sb.append(this.summary);
            sb.append(",");
        }
        if (this.text != null) {
            sb.append("text:");
            sb.append(this.text);
            sb.append(",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title);
            sb.append(",");
        }
        if (this.webhookUrl != null) {
            sb.append("webhookUrl:");
            sb.append(this.webhookUrl);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.remove((Object)"httpConfig");
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get((Object)"httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get((Object)"httpConfig").remove((Object)this.httpConfig);
        }
        return (A)((Object)this);
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public A withNewWebhookUrl(String key, String name, Boolean optional) {
        return this.withWebhookUrl(new SecretKeySelector(key, name, optional));
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)((Object)this);
    }

    public A withSummary(String summary) {
        this.summary = summary;
        return (A)((Object)this);
    }

    public A withText(String text) {
        this.text = text;
        return (A)((Object)this);
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public A withWebhookUrl(SecretKeySelector webhookUrl) {
        this.webhookUrl = webhookUrl;
        return (A)((Object)this);
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        public N and() {
            return (N)MSTeamsConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

