/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.EC2SDConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.Filter;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.FilterBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.FilterFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EC2SDConfigFluent<A extends EC2SDConfigFluent<A>>
extends BaseFluent<A> {
    private SecretKeySelector accessKey;
    private Map<String, Object> additionalProperties;
    private Boolean enableHTTP2;
    private ArrayList<FilterBuilder> filters = new ArrayList();
    private Boolean followRedirects;
    private String noProxy;
    private Integer port;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String refreshInterval;
    private String region;
    private String roleARN;
    private SecretKeySelector secretKey;
    private SafeTLSConfigBuilder tlsConfig;

    public EC2SDConfigFluent() {
    }

    public EC2SDConfigFluent(EC2SDConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToFilters(Collection<Filter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(Filter item) {
        return new FiltersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToFilters(Filter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)((Object)this);
    }

    public Filter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public List<Filter> buildFilters() {
        return this.filters != null ? EC2SDConfigFluent.build(this.filters) : null;
    }

    public Filter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public Filter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public Filter buildMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    protected void copyInstance(EC2SDConfig instance) {
        EC2SDConfig eC2SDConfig = instance = instance != null ? instance : new EC2SDConfig();
        if (instance != null) {
            this.withAccessKey(instance.getAccessKey());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withFilters(instance.getFilters());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNoProxy(instance.getNoProxy());
            this.withPort(instance.getPort());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withRegion(instance.getRegion());
            this.withRoleARN(instance.getRoleARN());
            this.withSecretKey(instance.getSecretKey());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<FilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "filters"));
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EC2SDConfigFluent that = (EC2SDConfigFluent)((Object)o);
        if (!Objects.equals(this.accessKey, that.accessKey)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.roleARN, that.roleARN)) {
            return false;
        }
        if (!Objects.equals(this.secretKey, that.secretKey)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public SecretKeySelector getAccessKey() {
        return this.accessKey;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public Integer getPort() {
        return this.port;
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public String getRegion() {
        return this.region;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public SecretKeySelector getSecretKey() {
        return this.secretKey;
    }

    public boolean hasAccessKey() {
        return this.accessKey != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public boolean hasMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public boolean hasRoleARN() {
        return this.roleARN != null;
    }

    public boolean hasSecretKey() {
        return this.secretKey != null;
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessKey, this.enableHTTP2, this.filters, this.followRedirects, this.noProxy, this.port, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.refreshInterval, this.region, this.roleARN, this.secretKey, this.tlsConfig, this.additionalProperties});
    }

    public A removeAllFromFilters(Collection<Filter> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(Filter ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFilters(Predicate<FilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        Iterator<FilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            FilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public FiltersNested<A> setNewFilterLike(int index, Filter item) {
        return new FiltersNested(index, item);
    }

    public A setToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKey != null) {
            sb.append("accessKey:");
            sb.append(this.accessKey);
            sb.append(",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2);
            sb.append(",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters);
            sb.append(",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects);
            sb.append(",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(this.proxyConnectHeader);
            sb.append(",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment);
            sb.append(",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl);
            sb.append(",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval);
            sb.append(",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region);
            sb.append(",");
        }
        if (this.roleARN != null) {
            sb.append("roleARN:");
            sb.append(this.roleARN);
            sb.append(",");
        }
        if (this.secretKey != null) {
            sb.append("secretKey:");
            sb.append(this.secretKey);
            sb.append(",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append((Object)this.tlsConfig);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAccessKey(SecretKeySelector accessKey) {
        this.accessKey = accessKey;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)((Object)this);
    }

    public A withFilters(List<Filter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(Filter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)((Object)this);
    }

    public A withNewAccessKey(String key, String name, Boolean optional) {
        return this.withAccessKey(new SecretKeySelector(key, name, optional));
    }

    public A withNewSecretKey(String key, String name, Boolean optional) {
        return this.withSecretKey(new SecretKeySelector(key, name, optional));
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)((Object)this);
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)((Object)this);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)((Object)this);
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)((Object)this);
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)((Object)this);
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)((Object)this);
    }

    public A withRoleARN(String roleARN) {
        this.roleARN = roleARN;
        return (A)((Object)this);
    }

    public A withSecretKey(SecretKeySelector secretKey) {
        this.secretKey = secretKey;
        return (A)((Object)this);
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)EC2SDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class FiltersNested<N>
    extends FilterFluent<FiltersNested<N>>
    implements Nested<N> {
        FilterBuilder builder;
        int index;

        FiltersNested(int index, Filter item) {
            this.index = index;
            this.builder = new FilterBuilder(this, item);
        }

        public N and() {
            return (N)EC2SDConfigFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }
}

