/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.ClusterTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterTLSConfigFluent<A extends ClusterTLSConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private SafeTLSConfigBuilder client;
    private WebTLSConfigBuilder server;

    public ClusterTLSConfigFluent() {
    }

    public ClusterTLSConfigFluent(ClusterTLSConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public SafeTLSConfig buildClient() {
        return this.client != null ? this.client.build() : null;
    }

    public WebTLSConfig buildServer() {
        return this.server != null ? this.server.build() : null;
    }

    protected void copyInstance(ClusterTLSConfig instance) {
        ClusterTLSConfig clusterTLSConfig = instance = instance != null ? instance : new ClusterTLSConfig();
        if (instance != null) {
            this.withClient(instance.getClient());
            this.withServer(instance.getServer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClientNested<A> editClient() {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(null));
    }

    public ClientNested<A> editOrNewClient() {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public ClientNested<A> editOrNewClientLike(SafeTLSConfig item) {
        return this.withNewClientLike(Optional.ofNullable(this.buildClient()).orElse(item));
    }

    public ServerNested<A> editOrNewServer() {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(new WebTLSConfigBuilder().build()));
    }

    public ServerNested<A> editOrNewServerLike(WebTLSConfig item) {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(item));
    }

    public ServerNested<A> editServer() {
        return this.withNewServerLike(Optional.ofNullable(this.buildServer()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterTLSConfigFluent that = (ClusterTLSConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.client, (Object)that.client)) {
            return false;
        }
        if (!Objects.equals((Object)this.server, (Object)that.server)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasClient() {
        return this.client != null;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.client, this.server, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.client != null) {
            sb.append("client:");
            sb.append((Object)this.client);
            sb.append(",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append((Object)this.server);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withClient(SafeTLSConfig client) {
        this._visitables.remove((Object)"client");
        if (client != null) {
            this.client = new SafeTLSConfigBuilder(client);
            this._visitables.get((Object)"client").add(this.client);
        } else {
            this.client = null;
            this._visitables.get((Object)"client").remove((Object)this.client);
        }
        return (A)((Object)this);
    }

    public ClientNested<A> withNewClient() {
        return new ClientNested(null);
    }

    public ClientNested<A> withNewClientLike(SafeTLSConfig item) {
        return new ClientNested(item);
    }

    public ServerNested<A> withNewServer() {
        return new ServerNested(null);
    }

    public ServerNested<A> withNewServerLike(WebTLSConfig item) {
        return new ServerNested(item);
    }

    public A withServer(WebTLSConfig server) {
        this._visitables.remove((Object)"server");
        if (server != null) {
            this.server = new WebTLSConfigBuilder(server);
            this._visitables.get((Object)"server").add(this.server);
        } else {
            this.server = null;
            this._visitables.get((Object)"server").remove((Object)this.server);
        }
        return (A)((Object)this);
    }

    public class ServerNested<N>
    extends WebTLSConfigFluent<ServerNested<N>>
    implements Nested<N> {
        WebTLSConfigBuilder builder;

        ServerNested(WebTLSConfig item) {
            this.builder = new WebTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ClusterTLSConfigFluent.this.withServer(this.builder.build());
        }

        public N endServer() {
            return this.and();
        }
    }

    public class ClientNested<N>
    extends SafeTLSConfigFluent<ClientNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        ClientNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ClusterTLSConfigFluent.this.withClient(this.builder.build());
        }

        public N endClient() {
            return this.and();
        }
    }
}

