/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.FileSDConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FileSDConfigFluent<A extends FileSDConfigFluent<A>>
extends BaseFluent<A> {
    private List<String> files = new ArrayList<String>();
    private String refreshInterval;
    private Map<String, Object> additionalProperties;

    public FileSDConfigFluent() {
    }

    public FileSDConfigFluent(FileSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FileSDConfig instance) {
        FileSDConfig fileSDConfig = instance = instance != null ? instance : new FileSDConfig();
        if (instance != null) {
            this.withFiles(instance.getFiles());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToFiles(int index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.add(index, item);
        return (A)((Object)this);
    }

    public A setToFiles(int index, String item) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        this.files.set(index, item);
        return (A)((Object)this);
    }

    public A addToFiles(String ... items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToFiles(Collection<String> items) {
        if (this.files == null) {
            this.files = new ArrayList<String>();
        }
        for (String item : items) {
            this.files.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromFiles(String ... items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.files.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFiles(Collection<String> items) {
        if (this.files == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.files.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getFile(int index) {
        return this.files.get(index);
    }

    public String getFirstFile() {
        return this.files.get(0);
    }

    public String getLastFile() {
        return this.files.get(this.files.size() - 1);
    }

    public String getMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingFile(Predicate<String> predicate) {
        for (String item : this.files) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFiles(List<String> files) {
        if (files != null) {
            this.files = new ArrayList<String>();
            for (String item : files) {
                this.addToFiles(item);
            }
        } else {
            this.files = null;
        }
        return (A)((Object)this);
    }

    public A withFiles(String ... files) {
        if (this.files != null) {
            this.files.clear();
            this._visitables.remove((Object)"files");
        }
        if (files != null) {
            for (String item : files) {
                this.addToFiles(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFiles() {
        return this.files != null && !this.files.isEmpty();
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)((Object)this);
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileSDConfigFluent that = (FileSDConfigFluent)((Object)o);
        if (!Objects.equals(this.files, that.files)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.files, this.refreshInterval, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.files != null && !this.files.isEmpty()) {
            sb.append("files:");
            sb.append(String.valueOf(this.files) + ",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

