/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.ConsulSDConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsulSDConfigFluent<A extends ConsulSDConfigFluent<A>>
extends BaseFluent<A> {
    private Boolean allowStale;
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String datacenter;
    private Boolean enableHTTP2;
    private String filter;
    private Boolean followRedirects;
    private String namespace;
    private String noProxy;
    private Map<String, String> nodeMeta;
    private OAuth2Builder oauth2;
    private String partition;
    private String pathPrefix;
    private Map<String, List<SecretKeySelector>> proxyConnectHeader;
    private Boolean proxyFromEnvironment;
    private String proxyUrl;
    private String refreshInterval;
    private String scheme;
    private String server;
    private List<String> services = new ArrayList<String>();
    private String tagSeparator;
    private List<String> tags = new ArrayList<String>();
    private SafeTLSConfigBuilder tlsConfig;
    private SecretKeySelector tokenRef;
    private Map<String, Object> additionalProperties;

    public ConsulSDConfigFluent() {
    }

    public ConsulSDConfigFluent(ConsulSDConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsulSDConfig instance) {
        ConsulSDConfig consulSDConfig = instance = instance != null ? instance : new ConsulSDConfig();
        if (instance != null) {
            this.withAllowStale(instance.getAllowStale());
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withDatacenter(instance.getDatacenter());
            this.withEnableHTTP2(instance.getEnableHTTP2());
            this.withFilter(instance.getFilter());
            this.withFollowRedirects(instance.getFollowRedirects());
            this.withNamespace(instance.getNamespace());
            this.withNoProxy(instance.getNoProxy());
            this.withNodeMeta(instance.getNodeMeta());
            this.withOauth2(instance.getOauth2());
            this.withPartition(instance.getPartition());
            this.withPathPrefix(instance.getPathPrefix());
            this.withProxyConnectHeader(instance.getProxyConnectHeader());
            this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
            this.withProxyUrl(instance.getProxyUrl());
            this.withRefreshInterval(instance.getRefreshInterval());
            this.withScheme(instance.getScheme());
            this.withServer(instance.getServer());
            this.withServices(instance.getServices());
            this.withTagSeparator(instance.getTagSeparator());
            this.withTags(instance.getTags());
            this.withTlsConfig(instance.getTlsConfig());
            this.withTokenRef(instance.getTokenRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowStale() {
        return this.allowStale;
    }

    public A withAllowStale(Boolean allowStale) {
        this.allowStale = allowStale;
        return (A)((Object)this);
    }

    public boolean hasAllowStale() {
        return this.allowStale != null;
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove((Object)"authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove((Object)"basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get((Object)"basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get((Object)"basicAuth").remove((Object)this.basicAuth);
        }
        return (A)((Object)this);
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public A withDatacenter(String datacenter) {
        this.datacenter = datacenter;
        return (A)((Object)this);
    }

    public boolean hasDatacenter() {
        return this.datacenter != null;
    }

    public Boolean getEnableHTTP2() {
        return this.enableHTTP2;
    }

    public A withEnableHTTP2(Boolean enableHTTP2) {
        this.enableHTTP2 = enableHTTP2;
        return (A)((Object)this);
    }

    public boolean hasEnableHTTP2() {
        return this.enableHTTP2 != null;
    }

    public String getFilter() {
        return this.filter;
    }

    public A withFilter(String filter) {
        this.filter = filter;
        return (A)((Object)this);
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public A withFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (A)((Object)this);
    }

    public boolean hasFollowRedirects() {
        return this.followRedirects != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getNoProxy() {
        return this.noProxy;
    }

    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)((Object)this);
    }

    public boolean hasNoProxy() {
        return this.noProxy != null;
    }

    public A addToNodeMeta(String key, String value) {
        if (this.nodeMeta == null && key != null && value != null) {
            this.nodeMeta = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeMeta.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeMeta(Map<String, String> map) {
        if (this.nodeMeta == null && map != null) {
            this.nodeMeta = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeMeta.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeMeta(String key) {
        if (this.nodeMeta == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeMeta != null) {
            this.nodeMeta.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeMeta(Map<String, String> map) {
        if (this.nodeMeta == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeMeta == null) continue;
                this.nodeMeta.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeMeta() {
        return this.nodeMeta;
    }

    public <K, V> A withNodeMeta(Map<String, String> nodeMeta) {
        this.nodeMeta = nodeMeta == null ? null : new LinkedHashMap<String, String>(nodeMeta);
        return (A)((Object)this);
    }

    public boolean hasNodeMeta() {
        return this.nodeMeta != null;
    }

    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    public A withOauth2(OAuth2 oauth2) {
        this._visitables.remove((Object)"oauth2");
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get((Object)"oauth2").add(this.oauth2);
        } else {
            this.oauth2 = null;
            this._visitables.get((Object)"oauth2").remove((Object)this.oauth2);
        }
        return (A)((Object)this);
    }

    public boolean hasOauth2() {
        return this.oauth2 != null;
    }

    public Oauth2Nested<A> withNewOauth2() {
        return new Oauth2Nested(null);
    }

    public Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2Nested(item);
    }

    public Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(null));
    }

    public Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(new OAuth2Builder().build()));
    }

    public Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(Optional.ofNullable(this.buildOauth2()).orElse(item));
    }

    public String getPartition() {
        return this.partition;
    }

    public A withPartition(String partition) {
        this.partition = partition;
        return (A)((Object)this);
    }

    public boolean hasPartition() {
        return this.partition != null;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public A withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return (A)((Object)this);
    }

    public boolean hasPathPrefix() {
        return this.pathPrefix != null;
    }

    public A addToProxyConnectHeader(String key, List<SecretKeySelector> value) {
        if (this.proxyConnectHeader == null && key != null && value != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (key != null && value != null) {
            this.proxyConnectHeader.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null && map != null) {
            this.proxyConnectHeader = new LinkedHashMap<String, List<SecretKeySelector>>();
        }
        if (map != null) {
            this.proxyConnectHeader.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(String key) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (key != null && this.proxyConnectHeader != null) {
            this.proxyConnectHeader.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProxyConnectHeader(Map<String, List<SecretKeySelector>> map) {
        if (this.proxyConnectHeader == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.proxyConnectHeader == null) continue;
                this.proxyConnectHeader.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, List<SecretKeySelector>> getProxyConnectHeader() {
        return this.proxyConnectHeader;
    }

    public <K, V> A withProxyConnectHeader(Map<String, List<SecretKeySelector>> proxyConnectHeader) {
        this.proxyConnectHeader = proxyConnectHeader == null ? null : new LinkedHashMap<String, List<SecretKeySelector>>(proxyConnectHeader);
        return (A)((Object)this);
    }

    public boolean hasProxyConnectHeader() {
        return this.proxyConnectHeader != null;
    }

    public Boolean getProxyFromEnvironment() {
        return this.proxyFromEnvironment;
    }

    public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
        this.proxyFromEnvironment = proxyFromEnvironment;
        return (A)((Object)this);
    }

    public boolean hasProxyFromEnvironment() {
        return this.proxyFromEnvironment != null;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)((Object)this);
    }

    public boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public A withRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)((Object)this);
    }

    public boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)((Object)this);
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)((Object)this);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)((Object)this);
    }

    public A setToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.set(index, item);
        return (A)((Object)this);
    }

    public A addToServices(String ... items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServices(Collection<String> items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServices(String ... items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.services.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServices(Collection<String> items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.services.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServices() {
        return this.services;
    }

    public String getService(int index) {
        return this.services.get(index);
    }

    public String getFirstService() {
        return this.services.get(0);
    }

    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServices(List<String> services) {
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)((Object)this);
    }

    public A withServices(String ... services) {
        if (this.services != null) {
            this.services.clear();
            this._visitables.remove((Object)"services");
        }
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public String getTagSeparator() {
        return this.tagSeparator;
    }

    public A withTagSeparator(String tagSeparator) {
        this.tagSeparator = tagSeparator;
        return (A)((Object)this);
    }

    public boolean hasTagSeparator() {
        return this.tagSeparator != null;
    }

    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)((Object)this);
    }

    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)((Object)this);
    }

    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(String ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<String> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.tags.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTag(int index) {
        return this.tags.get(index);
    }

    public String getFirstTag() {
        return this.tags.get(0);
    }

    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<String> tags) {
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public SecretKeySelector getTokenRef() {
        return this.tokenRef;
    }

    public A withTokenRef(SecretKeySelector tokenRef) {
        this.tokenRef = tokenRef;
        return (A)((Object)this);
    }

    public boolean hasTokenRef() {
        return this.tokenRef != null;
    }

    public A withNewTokenRef(String key, String name, Boolean optional) {
        return this.withTokenRef(new SecretKeySelector(key, name, optional));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsulSDConfigFluent that = (ConsulSDConfigFluent)((Object)o);
        if (!Objects.equals(this.allowStale, that.allowStale)) {
            return false;
        }
        if (!Objects.equals((Object)this.authorization, (Object)that.authorization)) {
            return false;
        }
        if (!Objects.equals((Object)this.basicAuth, (Object)that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.datacenter, that.datacenter)) {
            return false;
        }
        if (!Objects.equals(this.enableHTTP2, that.enableHTTP2)) {
            return false;
        }
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.followRedirects, that.followRedirects)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.nodeMeta, that.nodeMeta)) {
            return false;
        }
        if (!Objects.equals((Object)this.oauth2, (Object)that.oauth2)) {
            return false;
        }
        if (!Objects.equals(this.partition, that.partition)) {
            return false;
        }
        if (!Objects.equals(this.pathPrefix, that.pathPrefix)) {
            return false;
        }
        if (!Objects.equals(this.proxyConnectHeader, that.proxyConnectHeader)) {
            return false;
        }
        if (!Objects.equals(this.proxyFromEnvironment, that.proxyFromEnvironment)) {
            return false;
        }
        if (!Objects.equals(this.proxyUrl, that.proxyUrl)) {
            return false;
        }
        if (!Objects.equals(this.refreshInterval, that.refreshInterval)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.services, that.services)) {
            return false;
        }
        if (!Objects.equals(this.tagSeparator, that.tagSeparator)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.tokenRef, that.tokenRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowStale, this.authorization, this.basicAuth, this.datacenter, this.enableHTTP2, this.filter, this.followRedirects, this.namespace, this.noProxy, this.nodeMeta, this.oauth2, this.partition, this.pathPrefix, this.proxyConnectHeader, this.proxyFromEnvironment, this.proxyUrl, this.refreshInterval, this.scheme, this.server, this.services, this.tagSeparator, this.tags, this.tlsConfig, this.tokenRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowStale != null) {
            sb.append("allowStale:");
            sb.append(this.allowStale + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(String.valueOf((Object)this.authorization) + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(String.valueOf((Object)this.basicAuth) + ",");
        }
        if (this.datacenter != null) {
            sb.append("datacenter:");
            sb.append(this.datacenter + ",");
        }
        if (this.enableHTTP2 != null) {
            sb.append("enableHTTP2:");
            sb.append(this.enableHTTP2 + ",");
        }
        if (this.filter != null) {
            sb.append("filter:");
            sb.append(this.filter + ",");
        }
        if (this.followRedirects != null) {
            sb.append("followRedirects:");
            sb.append(this.followRedirects + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.nodeMeta != null && !this.nodeMeta.isEmpty()) {
            sb.append("nodeMeta:");
            sb.append(String.valueOf(this.nodeMeta) + ",");
        }
        if (this.oauth2 != null) {
            sb.append("oauth2:");
            sb.append(String.valueOf((Object)this.oauth2) + ",");
        }
        if (this.partition != null) {
            sb.append("partition:");
            sb.append(this.partition + ",");
        }
        if (this.pathPrefix != null) {
            sb.append("pathPrefix:");
            sb.append(this.pathPrefix + ",");
        }
        if (this.proxyConnectHeader != null && !this.proxyConnectHeader.isEmpty()) {
            sb.append("proxyConnectHeader:");
            sb.append(String.valueOf(this.proxyConnectHeader) + ",");
        }
        if (this.proxyFromEnvironment != null) {
            sb.append("proxyFromEnvironment:");
            sb.append(this.proxyFromEnvironment + ",");
        }
        if (this.proxyUrl != null) {
            sb.append("proxyUrl:");
            sb.append(this.proxyUrl + ",");
        }
        if (this.refreshInterval != null) {
            sb.append("refreshInterval:");
            sb.append(this.refreshInterval + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(String.valueOf(this.services) + ",");
        }
        if (this.tagSeparator != null) {
            sb.append("tagSeparator:");
            sb.append(this.tagSeparator + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(String.valueOf(this.tags) + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(String.valueOf((Object)this.tlsConfig) + ",");
        }
        if (this.tokenRef != null) {
            sb.append("tokenRef:");
            sb.append(String.valueOf(this.tokenRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowStale() {
        return this.withAllowStale(true);
    }

    public A withEnableHTTP2() {
        return this.withEnableHTTP2(true);
    }

    public A withFollowRedirects() {
        return this.withFollowRedirects(true);
    }

    public A withProxyFromEnvironment() {
        return this.withProxyFromEnvironment(true);
    }

    public class TlsConfigNested<N>
    extends SafeTLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNested(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)ConsulSDConfigFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2Nested<N>
    extends OAuth2Fluent<Oauth2Nested<N>>
    implements Nested<N> {
        OAuth2Builder builder;

        Oauth2Nested(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        public N and() {
            return (N)ConsulSDConfigFluent.this.withOauth2(this.builder.build());
        }

        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        public N and() {
            return (N)ConsulSDConfigFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)ConsulSDConfigFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }
}

