/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.EphemeralVolumeSource;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaim;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaimBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedPersistentVolumeClaimFluent;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StorageSpecFluent<A extends StorageSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean disableMountSubPath;
    private EmptyDirVolumeSource emptyDir;
    private EphemeralVolumeSource ephemeral;
    private EmbeddedPersistentVolumeClaimBuilder volumeClaimTemplate;
    private Map<String, Object> additionalProperties;

    public StorageSpecFluent() {
    }

    public StorageSpecFluent(StorageSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(StorageSpec instance) {
        StorageSpec storageSpec = instance = instance != null ? instance : new StorageSpec();
        if (instance != null) {
            this.withDisableMountSubPath(instance.getDisableMountSubPath());
            this.withEmptyDir(instance.getEmptyDir());
            this.withEphemeral(instance.getEphemeral());
            this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getDisableMountSubPath() {
        return this.disableMountSubPath;
    }

    public A withDisableMountSubPath(Boolean disableMountSubPath) {
        this.disableMountSubPath = disableMountSubPath;
        return (A)((Object)this);
    }

    public boolean hasDisableMountSubPath() {
        return this.disableMountSubPath != null;
    }

    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
        return (A)((Object)this);
    }

    public boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    public EphemeralVolumeSource getEphemeral() {
        return this.ephemeral;
    }

    public A withEphemeral(EphemeralVolumeSource ephemeral) {
        this.ephemeral = ephemeral;
        return (A)((Object)this);
    }

    public boolean hasEphemeral() {
        return this.ephemeral != null;
    }

    public EmbeddedPersistentVolumeClaim buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    public A withVolumeClaimTemplate(EmbeddedPersistentVolumeClaim volumeClaimTemplate) {
        this._visitables.remove((Object)"volumeClaimTemplate");
        if (volumeClaimTemplate != null) {
            this.volumeClaimTemplate = new EmbeddedPersistentVolumeClaimBuilder(volumeClaimTemplate);
            this._visitables.get((Object)"volumeClaimTemplate").add(this.volumeClaimTemplate);
        } else {
            this.volumeClaimTemplate = null;
            this._visitables.get((Object)"volumeClaimTemplate").remove((Object)this.volumeClaimTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    public VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNested(null);
    }

    public VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return new VolumeClaimTemplateNested(item);
    }

    public VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(Optional.ofNullable(this.buildVolumeClaimTemplate()).orElse(null));
    }

    public VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(Optional.ofNullable(this.buildVolumeClaimTemplate()).orElse(new EmbeddedPersistentVolumeClaimBuilder().build()));
    }

    public VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return this.withNewVolumeClaimTemplateLike(Optional.ofNullable(this.buildVolumeClaimTemplate()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageSpecFluent that = (StorageSpecFluent)((Object)o);
        if (!Objects.equals(this.disableMountSubPath, that.disableMountSubPath)) {
            return false;
        }
        if (!Objects.equals(this.emptyDir, that.emptyDir)) {
            return false;
        }
        if (!Objects.equals(this.ephemeral, that.ephemeral)) {
            return false;
        }
        if (!Objects.equals((Object)this.volumeClaimTemplate, (Object)that.volumeClaimTemplate)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.disableMountSubPath, this.emptyDir, this.ephemeral, this.volumeClaimTemplate, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.disableMountSubPath != null) {
            sb.append("disableMountSubPath:");
            sb.append(this.disableMountSubPath + ",");
        }
        if (this.emptyDir != null) {
            sb.append("emptyDir:");
            sb.append(String.valueOf(this.emptyDir) + ",");
        }
        if (this.ephemeral != null) {
            sb.append("ephemeral:");
            sb.append(String.valueOf(this.ephemeral) + ",");
        }
        if (this.volumeClaimTemplate != null) {
            sb.append("volumeClaimTemplate:");
            sb.append(String.valueOf((Object)this.volumeClaimTemplate) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withDisableMountSubPath() {
        return this.withDisableMountSubPath(true);
    }

    public class VolumeClaimTemplateNested<N>
    extends EmbeddedPersistentVolumeClaimFluent<VolumeClaimTemplateNested<N>>
    implements Nested<N> {
        EmbeddedPersistentVolumeClaimBuilder builder;

        VolumeClaimTemplateNested(EmbeddedPersistentVolumeClaim item) {
            this.builder = new EmbeddedPersistentVolumeClaimBuilder(this, item);
        }

        public N and() {
            return (N)StorageSpecFluent.this.withVolumeClaimTemplate(this.builder.build());
        }

        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

