/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadata;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AttachMetadataFluent;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluent;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodMonitorSpecFluent<A extends PodMonitorSpecFluent<A>>
extends BaseFluent<A> {
    private AttachMetadataBuilder attachMetadata;
    private String bodySizeLimit;
    private String fallbackScrapeProtocol;
    private String jobLabel;
    private Long keepDroppedTargets;
    private Long labelLimit;
    private Long labelNameLengthLimit;
    private Long labelValueLengthLimit;
    private NamespaceSelectorBuilder namespaceSelector;
    private Long nativeHistogramBucketLimit;
    private Quantity nativeHistogramMinBucketFactor;
    private ArrayList<PodMetricsEndpointBuilder> podMetricsEndpoints = new ArrayList();
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private String scrapeClass;
    private Boolean scrapeClassicHistograms;
    private List<String> scrapeProtocols = new ArrayList<String>();
    private LabelSelectorBuilder selector;
    private String selectorMechanism;
    private Long targetLimit;
    private Map<String, Object> additionalProperties;

    public PodMonitorSpecFluent() {
    }

    public PodMonitorSpecFluent(PodMonitorSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodMonitorSpec instance) {
        PodMonitorSpec podMonitorSpec = instance = instance != null ? instance : new PodMonitorSpec();
        if (instance != null) {
            this.withAttachMetadata(instance.getAttachMetadata());
            this.withBodySizeLimit(instance.getBodySizeLimit());
            this.withFallbackScrapeProtocol(instance.getFallbackScrapeProtocol());
            this.withJobLabel(instance.getJobLabel());
            this.withKeepDroppedTargets(instance.getKeepDroppedTargets());
            this.withLabelLimit(instance.getLabelLimit());
            this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
            this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withNativeHistogramBucketLimit(instance.getNativeHistogramBucketLimit());
            this.withNativeHistogramMinBucketFactor(instance.getNativeHistogramMinBucketFactor());
            this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
            this.withPodTargetLabels(instance.getPodTargetLabels());
            this.withSampleLimit(instance.getSampleLimit());
            this.withScrapeClass(instance.getScrapeClass());
            this.withScrapeClassicHistograms(instance.getScrapeClassicHistograms());
            this.withScrapeProtocols(instance.getScrapeProtocols());
            this.withSelector(instance.getSelector());
            this.withSelectorMechanism(instance.getSelectorMechanism());
            this.withTargetLimit(instance.getTargetLimit());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AttachMetadata buildAttachMetadata() {
        return this.attachMetadata != null ? this.attachMetadata.build() : null;
    }

    public A withAttachMetadata(AttachMetadata attachMetadata) {
        this._visitables.remove((Object)"attachMetadata");
        if (attachMetadata != null) {
            this.attachMetadata = new AttachMetadataBuilder(attachMetadata);
            this._visitables.get((Object)"attachMetadata").add(this.attachMetadata);
        } else {
            this.attachMetadata = null;
            this._visitables.get((Object)"attachMetadata").remove((Object)this.attachMetadata);
        }
        return (A)((Object)this);
    }

    public boolean hasAttachMetadata() {
        return this.attachMetadata != null;
    }

    public A withNewAttachMetadata(Boolean node) {
        return this.withAttachMetadata(new AttachMetadata(node));
    }

    public AttachMetadataNested<A> withNewAttachMetadata() {
        return new AttachMetadataNested(null);
    }

    public AttachMetadataNested<A> withNewAttachMetadataLike(AttachMetadata item) {
        return new AttachMetadataNested(item);
    }

    public AttachMetadataNested<A> editAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(null));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadata() {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(new AttachMetadataBuilder().build()));
    }

    public AttachMetadataNested<A> editOrNewAttachMetadataLike(AttachMetadata item) {
        return this.withNewAttachMetadataLike(Optional.ofNullable(this.buildAttachMetadata()).orElse(item));
    }

    public String getBodySizeLimit() {
        return this.bodySizeLimit;
    }

    public A withBodySizeLimit(String bodySizeLimit) {
        this.bodySizeLimit = bodySizeLimit;
        return (A)((Object)this);
    }

    public boolean hasBodySizeLimit() {
        return this.bodySizeLimit != null;
    }

    public String getFallbackScrapeProtocol() {
        return this.fallbackScrapeProtocol;
    }

    public A withFallbackScrapeProtocol(String fallbackScrapeProtocol) {
        this.fallbackScrapeProtocol = fallbackScrapeProtocol;
        return (A)((Object)this);
    }

    public boolean hasFallbackScrapeProtocol() {
        return this.fallbackScrapeProtocol != null;
    }

    public String getJobLabel() {
        return this.jobLabel;
    }

    public A withJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return (A)((Object)this);
    }

    public boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    public Long getKeepDroppedTargets() {
        return this.keepDroppedTargets;
    }

    public A withKeepDroppedTargets(Long keepDroppedTargets) {
        this.keepDroppedTargets = keepDroppedTargets;
        return (A)((Object)this);
    }

    public boolean hasKeepDroppedTargets() {
        return this.keepDroppedTargets != null;
    }

    public Long getLabelLimit() {
        return this.labelLimit;
    }

    public A withLabelLimit(Long labelLimit) {
        this.labelLimit = labelLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelLimit() {
        return this.labelLimit != null;
    }

    public Long getLabelNameLengthLimit() {
        return this.labelNameLengthLimit;
    }

    public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
        this.labelNameLengthLimit = labelNameLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelNameLengthLimit() {
        return this.labelNameLengthLimit != null;
    }

    public Long getLabelValueLengthLimit() {
        return this.labelValueLengthLimit;
    }

    public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
        this.labelValueLengthLimit = labelValueLengthLimit;
        return (A)((Object)this);
    }

    public boolean hasLabelValueLengthLimit() {
        return this.labelValueLengthLimit != null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.remove((Object)"namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove((Object)this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public Long getNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit;
    }

    public A withNativeHistogramBucketLimit(Long nativeHistogramBucketLimit) {
        this.nativeHistogramBucketLimit = nativeHistogramBucketLimit;
        return (A)((Object)this);
    }

    public boolean hasNativeHistogramBucketLimit() {
        return this.nativeHistogramBucketLimit != null;
    }

    public Quantity getNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor;
    }

    public A withNativeHistogramMinBucketFactor(Quantity nativeHistogramMinBucketFactor) {
        this.nativeHistogramMinBucketFactor = nativeHistogramMinBucketFactor;
        return (A)((Object)this);
    }

    public boolean hasNativeHistogramMinBucketFactor() {
        return this.nativeHistogramMinBucketFactor != null;
    }

    public A withNewNativeHistogramMinBucketFactor(String amount, String format) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount, format));
    }

    public A withNewNativeHistogramMinBucketFactor(String amount) {
        return this.withNativeHistogramMinBucketFactor(new Quantity(amount));
    }

    public A addToPodMetricsEndpoints(int index, PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
        if (index < 0 || index >= this.podMetricsEndpoints.size()) {
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"podMetricsEndpoints").add(index, builder);
            this.podMetricsEndpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPodMetricsEndpoints(int index, PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
        if (index < 0 || index >= this.podMetricsEndpoints.size()) {
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"podMetricsEndpoints").set(index, builder);
            this.podMetricsEndpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPodMetricsEndpoints(PodMetricsEndpoint ... items) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPodMetricsEndpoints(PodMetricsEndpoint ... items) {
        if (this.podMetricsEndpoints == null) {
            return (A)((Object)this);
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").remove((Object)builder);
            this.podMetricsEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        if (this.podMetricsEndpoints == null) {
            return (A)((Object)this);
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").remove((Object)builder);
            this.podMetricsEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate) {
        if (this.podMetricsEndpoints == null) {
            return (A)((Object)this);
        }
        Iterator<PodMetricsEndpointBuilder> each = this.podMetricsEndpoints.iterator();
        List visitables = this._visitables.get((Object)"podMetricsEndpoints");
        while (each.hasNext()) {
            PodMetricsEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<PodMetricsEndpoint> buildPodMetricsEndpoints() {
        return this.podMetricsEndpoints != null ? PodMonitorSpecFluent.build(this.podMetricsEndpoints) : null;
    }

    public PodMetricsEndpoint buildPodMetricsEndpoint(int index) {
        return this.podMetricsEndpoints.get(index).build();
    }

    public PodMetricsEndpoint buildFirstPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(0).build();
    }

    public PodMetricsEndpoint buildLastPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(this.podMetricsEndpoints.size() - 1).build();
    }

    public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item : this.podMetricsEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item : this.podMetricsEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) {
            this._visitables.get((Object)"podMetricsEndpoints").clear();
        }
        if (podMetricsEndpoints != null) {
            this.podMetricsEndpoints = new ArrayList();
            for (PodMetricsEndpoint item : podMetricsEndpoints) {
                this.addToPodMetricsEndpoints(item);
            }
        } else {
            this.podMetricsEndpoints = null;
        }
        return (A)((Object)this);
    }

    public A withPodMetricsEndpoints(PodMetricsEndpoint ... podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) {
            this.podMetricsEndpoints.clear();
            this._visitables.remove((Object)"podMetricsEndpoints");
        }
        if (podMetricsEndpoints != null) {
            for (PodMetricsEndpoint item : podMetricsEndpoints) {
                this.addToPodMetricsEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodMetricsEndpoints() {
        return this.podMetricsEndpoints != null && !this.podMetricsEndpoints.isEmpty();
    }

    public PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint() {
        return new PodMetricsEndpointsNested(-1, null);
    }

    public PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNested(-1, item);
    }

    public PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(int index, PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNested(index, item);
    }

    public PodMetricsEndpointsNested<A> editPodMetricsEndpoint(int index) {
        if (this.podMetricsEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit podMetricsEndpoints. Index exceeds size.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    public PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint() {
        if (this.podMetricsEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first podMetricsEndpoints. The list is empty.");
        }
        return this.setNewPodMetricsEndpointLike(0, this.buildPodMetricsEndpoint(0));
    }

    public PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint() {
        int index = this.podMetricsEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podMetricsEndpoints. The list is empty.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    public PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podMetricsEndpoints.size(); ++i) {
            if (!predicate.test(this.podMetricsEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podMetricsEndpoints. No match found.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    public A addToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToPodTargetLabels(int index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podTargetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podTargetLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public String getPodTargetLabel(int index) {
        return this.podTargetLabels.get(index);
    }

    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(this.podTargetLabels.size() - 1);
    }

    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (podTargetLabels != null) {
            this.podTargetLabels = new ArrayList<String>();
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        } else {
            this.podTargetLabels = null;
        }
        return (A)((Object)this);
    }

    public A withPodTargetLabels(String ... podTargetLabels) {
        if (this.podTargetLabels != null) {
            this.podTargetLabels.clear();
            this._visitables.remove((Object)"podTargetLabels");
        }
        if (podTargetLabels != null) {
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodTargetLabels() {
        return this.podTargetLabels != null && !this.podTargetLabels.isEmpty();
    }

    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)((Object)this);
    }

    public boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    public String getScrapeClass() {
        return this.scrapeClass;
    }

    public A withScrapeClass(String scrapeClass) {
        this.scrapeClass = scrapeClass;
        return (A)((Object)this);
    }

    public boolean hasScrapeClass() {
        return this.scrapeClass != null;
    }

    public Boolean getScrapeClassicHistograms() {
        return this.scrapeClassicHistograms;
    }

    public A withScrapeClassicHistograms(Boolean scrapeClassicHistograms) {
        this.scrapeClassicHistograms = scrapeClassicHistograms;
        return (A)((Object)this);
    }

    public boolean hasScrapeClassicHistograms() {
        return this.scrapeClassicHistograms != null;
    }

    public A addToScrapeProtocols(int index, String item) {
        if (this.scrapeProtocols == null) {
            this.scrapeProtocols = new ArrayList<String>();
        }
        this.scrapeProtocols.add(index, item);
        return (A)((Object)this);
    }

    public A setToScrapeProtocols(int index, String item) {
        if (this.scrapeProtocols == null) {
            this.scrapeProtocols = new ArrayList<String>();
        }
        this.scrapeProtocols.set(index, item);
        return (A)((Object)this);
    }

    public A addToScrapeProtocols(String ... items) {
        if (this.scrapeProtocols == null) {
            this.scrapeProtocols = new ArrayList<String>();
        }
        for (String item : items) {
            this.scrapeProtocols.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToScrapeProtocols(Collection<String> items) {
        if (this.scrapeProtocols == null) {
            this.scrapeProtocols = new ArrayList<String>();
        }
        for (String item : items) {
            this.scrapeProtocols.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromScrapeProtocols(String ... items) {
        if (this.scrapeProtocols == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scrapeProtocols.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromScrapeProtocols(Collection<String> items) {
        if (this.scrapeProtocols == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.scrapeProtocols.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getScrapeProtocols() {
        return this.scrapeProtocols;
    }

    public String getScrapeProtocol(int index) {
        return this.scrapeProtocols.get(index);
    }

    public String getFirstScrapeProtocol() {
        return this.scrapeProtocols.get(0);
    }

    public String getLastScrapeProtocol() {
        return this.scrapeProtocols.get(this.scrapeProtocols.size() - 1);
    }

    public String getMatchingScrapeProtocol(Predicate<String> predicate) {
        for (String item : this.scrapeProtocols) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingScrapeProtocol(Predicate<String> predicate) {
        for (String item : this.scrapeProtocols) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withScrapeProtocols(List<String> scrapeProtocols) {
        if (scrapeProtocols != null) {
            this.scrapeProtocols = new ArrayList<String>();
            for (String item : scrapeProtocols) {
                this.addToScrapeProtocols(item);
            }
        } else {
            this.scrapeProtocols = null;
        }
        return (A)((Object)this);
    }

    public A withScrapeProtocols(String ... scrapeProtocols) {
        if (this.scrapeProtocols != null) {
            this.scrapeProtocols.clear();
            this._visitables.remove((Object)"scrapeProtocols");
        }
        if (scrapeProtocols != null) {
            for (String item : scrapeProtocols) {
                this.addToScrapeProtocols(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasScrapeProtocols() {
        return this.scrapeProtocols != null && !this.scrapeProtocols.isEmpty();
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public String getSelectorMechanism() {
        return this.selectorMechanism;
    }

    public A withSelectorMechanism(String selectorMechanism) {
        this.selectorMechanism = selectorMechanism;
        return (A)((Object)this);
    }

    public boolean hasSelectorMechanism() {
        return this.selectorMechanism != null;
    }

    public Long getTargetLimit() {
        return this.targetLimit;
    }

    public A withTargetLimit(Long targetLimit) {
        this.targetLimit = targetLimit;
        return (A)((Object)this);
    }

    public boolean hasTargetLimit() {
        return this.targetLimit != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodMonitorSpecFluent that = (PodMonitorSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.attachMetadata, (Object)that.attachMetadata)) {
            return false;
        }
        if (!Objects.equals(this.bodySizeLimit, that.bodySizeLimit)) {
            return false;
        }
        if (!Objects.equals(this.fallbackScrapeProtocol, that.fallbackScrapeProtocol)) {
            return false;
        }
        if (!Objects.equals(this.jobLabel, that.jobLabel)) {
            return false;
        }
        if (!Objects.equals(this.keepDroppedTargets, that.keepDroppedTargets)) {
            return false;
        }
        if (!Objects.equals(this.labelLimit, that.labelLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelNameLengthLimit, that.labelNameLengthLimit)) {
            return false;
        }
        if (!Objects.equals(this.labelValueLengthLimit, that.labelValueLengthLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.namespaceSelector, (Object)that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.nativeHistogramBucketLimit, that.nativeHistogramBucketLimit)) {
            return false;
        }
        if (!Objects.equals(this.nativeHistogramMinBucketFactor, that.nativeHistogramMinBucketFactor)) {
            return false;
        }
        if (!Objects.equals(this.podMetricsEndpoints, that.podMetricsEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.podTargetLabels, that.podTargetLabels)) {
            return false;
        }
        if (!Objects.equals(this.sampleLimit, that.sampleLimit)) {
            return false;
        }
        if (!Objects.equals(this.scrapeClass, that.scrapeClass)) {
            return false;
        }
        if (!Objects.equals(this.scrapeClassicHistograms, that.scrapeClassicHistograms)) {
            return false;
        }
        if (!Objects.equals(this.scrapeProtocols, that.scrapeProtocols)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.selectorMechanism, that.selectorMechanism)) {
            return false;
        }
        if (!Objects.equals(this.targetLimit, that.targetLimit)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachMetadata, this.bodySizeLimit, this.fallbackScrapeProtocol, this.jobLabel, this.keepDroppedTargets, this.labelLimit, this.labelNameLengthLimit, this.labelValueLengthLimit, this.namespaceSelector, this.nativeHistogramBucketLimit, this.nativeHistogramMinBucketFactor, this.podMetricsEndpoints, this.podTargetLabels, this.sampleLimit, this.scrapeClass, this.scrapeClassicHistograms, this.scrapeProtocols, this.selector, this.selectorMechanism, this.targetLimit, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachMetadata != null) {
            sb.append("attachMetadata:");
            sb.append(this.attachMetadata + ",");
        }
        if (this.bodySizeLimit != null) {
            sb.append("bodySizeLimit:");
            sb.append(this.bodySizeLimit + ",");
        }
        if (this.fallbackScrapeProtocol != null) {
            sb.append("fallbackScrapeProtocol:");
            sb.append(this.fallbackScrapeProtocol + ",");
        }
        if (this.jobLabel != null) {
            sb.append("jobLabel:");
            sb.append(this.jobLabel + ",");
        }
        if (this.keepDroppedTargets != null) {
            sb.append("keepDroppedTargets:");
            sb.append(this.keepDroppedTargets + ",");
        }
        if (this.labelLimit != null) {
            sb.append("labelLimit:");
            sb.append(this.labelLimit + ",");
        }
        if (this.labelNameLengthLimit != null) {
            sb.append("labelNameLengthLimit:");
            sb.append(this.labelNameLengthLimit + ",");
        }
        if (this.labelValueLengthLimit != null) {
            sb.append("labelValueLengthLimit:");
            sb.append(this.labelValueLengthLimit + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.nativeHistogramBucketLimit != null) {
            sb.append("nativeHistogramBucketLimit:");
            sb.append(this.nativeHistogramBucketLimit + ",");
        }
        if (this.nativeHistogramMinBucketFactor != null) {
            sb.append("nativeHistogramMinBucketFactor:");
            sb.append(this.nativeHistogramMinBucketFactor + ",");
        }
        if (this.podMetricsEndpoints != null && !this.podMetricsEndpoints.isEmpty()) {
            sb.append("podMetricsEndpoints:");
            sb.append(this.podMetricsEndpoints + ",");
        }
        if (this.podTargetLabels != null && !this.podTargetLabels.isEmpty()) {
            sb.append("podTargetLabels:");
            sb.append(this.podTargetLabels + ",");
        }
        if (this.sampleLimit != null) {
            sb.append("sampleLimit:");
            sb.append(this.sampleLimit + ",");
        }
        if (this.scrapeClass != null) {
            sb.append("scrapeClass:");
            sb.append(this.scrapeClass + ",");
        }
        if (this.scrapeClassicHistograms != null) {
            sb.append("scrapeClassicHistograms:");
            sb.append(this.scrapeClassicHistograms + ",");
        }
        if (this.scrapeProtocols != null && !this.scrapeProtocols.isEmpty()) {
            sb.append("scrapeProtocols:");
            sb.append(this.scrapeProtocols + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.selectorMechanism != null) {
            sb.append("selectorMechanism:");
            sb.append(this.selectorMechanism + ",");
        }
        if (this.targetLimit != null) {
            sb.append("targetLimit:");
            sb.append(this.targetLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withScrapeClassicHistograms() {
        return this.withScrapeClassicHistograms(true);
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)PodMonitorSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class PodMetricsEndpointsNested<N>
    extends PodMetricsEndpointFluent<PodMetricsEndpointsNested<N>>
    implements Nested<N> {
        PodMetricsEndpointBuilder builder;
        int index;

        PodMetricsEndpointsNested(int index, PodMetricsEndpoint item) {
            this.index = index;
            this.builder = new PodMetricsEndpointBuilder(this, item);
        }

        public N and() {
            return (N)PodMonitorSpecFluent.this.setToPodMetricsEndpoints(this.index, this.builder.build());
        }

        public N endPodMetricsEndpoint() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends NamespaceSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        NamespaceSelectorBuilder builder;

        NamespaceSelectorNested(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        public N and() {
            return (N)PodMonitorSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class AttachMetadataNested<N>
    extends AttachMetadataFluent<AttachMetadataNested<N>>
    implements Nested<N> {
        AttachMetadataBuilder builder;

        AttachMetadataNested(AttachMetadata item) {
            this.builder = new AttachMetadataBuilder(this, item);
        }

        public N and() {
            return (N)PodMonitorSpecFluent.this.withAttachMetadata(this.builder.build());
        }

        public N endAttachMetadata() {
            return this.and();
        }
    }
}

