package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluent;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ScalewaySDConfigFluent<A extends ScalewaySDConfigFluent<A>> extends BaseFluent<A>{
  public ScalewaySDConfigFluent() {
  }
  
  public ScalewaySDConfigFluent(ScalewaySDConfig instance) {
    this.copyInstance(instance);
  }
  private String accessKey;
  private String apiURL;
  private Boolean enableHTTP2;
  private Boolean followRedirects;
  private String nameFilter;
  private String noProxy;
  private Integer port;
  private String projectID;
  private Map<String,List<SecretKeySelector>> proxyConnectHeader;
  private Boolean proxyFromEnvironment;
  private String proxyUrl;
  private String refreshInterval;
  private String role;
  private SecretKeySelector secretKey;
  private List<String> tagsFilter = new ArrayList<String>();
  private SafeTLSConfigBuilder tlsConfig;
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ScalewaySDConfig instance) {
    instance = (instance != null ? instance : new ScalewaySDConfig());
    if (instance != null) {
          this.withAccessKey(instance.getAccessKey());
          this.withApiURL(instance.getApiURL());
          this.withEnableHTTP2(instance.getEnableHTTP2());
          this.withFollowRedirects(instance.getFollowRedirects());
          this.withNameFilter(instance.getNameFilter());
          this.withNoProxy(instance.getNoProxy());
          this.withPort(instance.getPort());
          this.withProjectID(instance.getProjectID());
          this.withProxyConnectHeader(instance.getProxyConnectHeader());
          this.withProxyFromEnvironment(instance.getProxyFromEnvironment());
          this.withProxyUrl(instance.getProxyUrl());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withRole(instance.getRole());
          this.withSecretKey(instance.getSecretKey());
          this.withTagsFilter(instance.getTagsFilter());
          this.withTlsConfig(instance.getTlsConfig());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAccessKey() {
    return this.accessKey;
  }
  
  public A withAccessKey(String accessKey) {
    this.accessKey = accessKey;
    return (A) this;
  }
  
  public boolean hasAccessKey() {
    return this.accessKey != null;
  }
  
  public String getApiURL() {
    return this.apiURL;
  }
  
  public A withApiURL(String apiURL) {
    this.apiURL = apiURL;
    return (A) this;
  }
  
  public boolean hasApiURL() {
    return this.apiURL != null;
  }
  
  public Boolean getEnableHTTP2() {
    return this.enableHTTP2;
  }
  
  public A withEnableHTTP2(Boolean enableHTTP2) {
    this.enableHTTP2 = enableHTTP2;
    return (A) this;
  }
  
  public boolean hasEnableHTTP2() {
    return this.enableHTTP2 != null;
  }
  
  public Boolean getFollowRedirects() {
    return this.followRedirects;
  }
  
  public A withFollowRedirects(Boolean followRedirects) {
    this.followRedirects = followRedirects;
    return (A) this;
  }
  
  public boolean hasFollowRedirects() {
    return this.followRedirects != null;
  }
  
  public String getNameFilter() {
    return this.nameFilter;
  }
  
  public A withNameFilter(String nameFilter) {
    this.nameFilter = nameFilter;
    return (A) this;
  }
  
  public boolean hasNameFilter() {
    return this.nameFilter != null;
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getProjectID() {
    return this.projectID;
  }
  
  public A withProjectID(String projectID) {
    this.projectID = projectID;
    return (A) this;
  }
  
  public boolean hasProjectID() {
    return this.projectID != null;
  }
  
  public A addToProxyConnectHeader(String key,List<SecretKeySelector> value) {
    if(this.proxyConnectHeader == null && key != null && value != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(key != null && value != null) {this.proxyConnectHeader.put(key, value);} return (A)this;
  }
  
  public A addToProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null && map != null) { this.proxyConnectHeader = new LinkedHashMap(); }
    if(map != null) { this.proxyConnectHeader.putAll(map);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(String key) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(key != null && this.proxyConnectHeader != null) {this.proxyConnectHeader.remove(key);} return (A)this;
  }
  
  public A removeFromProxyConnectHeader(Map<String,List<SecretKeySelector>> map) {
    if(this.proxyConnectHeader == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.proxyConnectHeader != null){this.proxyConnectHeader.remove(key);}}} return (A)this;
  }
  
  public Map<String,List<SecretKeySelector>> getProxyConnectHeader() {
    return this.proxyConnectHeader;
  }
  
  public <K,V>A withProxyConnectHeader(Map<String,List<SecretKeySelector>> proxyConnectHeader) {
    if (proxyConnectHeader == null) {
      this.proxyConnectHeader = null;
    } else {
      this.proxyConnectHeader = new LinkedHashMap(proxyConnectHeader);
    }
    return (A) this;
  }
  
  public boolean hasProxyConnectHeader() {
    return this.proxyConnectHeader != null;
  }
  
  public Boolean getProxyFromEnvironment() {
    return this.proxyFromEnvironment;
  }
  
  public A withProxyFromEnvironment(Boolean proxyFromEnvironment) {
    this.proxyFromEnvironment = proxyFromEnvironment;
    return (A) this;
  }
  
  public boolean hasProxyFromEnvironment() {
    return this.proxyFromEnvironment != null;
  }
  
  public String getProxyUrl() {
    return this.proxyUrl;
  }
  
  public A withProxyUrl(String proxyUrl) {
    this.proxyUrl = proxyUrl;
    return (A) this;
  }
  
  public boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public String getRole() {
    return this.role;
  }
  
  public A withRole(String role) {
    this.role = role;
    return (A) this;
  }
  
  public boolean hasRole() {
    return this.role != null;
  }
  
  public SecretKeySelector getSecretKey() {
    return this.secretKey;
  }
  
  public A withSecretKey(SecretKeySelector secretKey) {
    this.secretKey = secretKey;
    return (A) this;
  }
  
  public boolean hasSecretKey() {
    return this.secretKey != null;
  }
  
  public A withNewSecretKey(String key,String name,Boolean optional) {
    return (A)withSecretKey(new SecretKeySelector(key, name, optional));
  }
  
  public A addToTagsFilter(int index,String item) {
    if (this.tagsFilter == null) {this.tagsFilter = new ArrayList<String>();}
    this.tagsFilter.add(index, item);
    return (A)this;
  }
  
  public A setToTagsFilter(int index,String item) {
    if (this.tagsFilter == null) {this.tagsFilter = new ArrayList<String>();}
    this.tagsFilter.set(index, item); return (A)this;
  }
  
  public A addToTagsFilter(java.lang.String... items) {
    if (this.tagsFilter == null) {this.tagsFilter = new ArrayList<String>();}
    for (String item : items) {this.tagsFilter.add(item);} return (A)this;
  }
  
  public A addAllToTagsFilter(Collection<String> items) {
    if (this.tagsFilter == null) {this.tagsFilter = new ArrayList<String>();}
    for (String item : items) {this.tagsFilter.add(item);} return (A)this;
  }
  
  public A removeFromTagsFilter(java.lang.String... items) {
    if (this.tagsFilter == null) return (A)this;
    for (String item : items) { this.tagsFilter.remove(item);} return (A)this;
  }
  
  public A removeAllFromTagsFilter(Collection<String> items) {
    if (this.tagsFilter == null) return (A)this;
    for (String item : items) { this.tagsFilter.remove(item);} return (A)this;
  }
  
  public List<String> getTagsFilter() {
    return this.tagsFilter;
  }
  
  public String getTagsFilter(int index) {
    return this.tagsFilter.get(index);
  }
  
  public String getFirstTagsFilter() {
    return this.tagsFilter.get(0);
  }
  
  public String getLastTagsFilter() {
    return this.tagsFilter.get(tagsFilter.size() - 1);
  }
  
  public String getMatchingTagsFilter(Predicate<String> predicate) {
      for (String item : tagsFilter) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTagsFilter(Predicate<String> predicate) {
      for (String item : tagsFilter) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTagsFilter(List<String> tagsFilter) {
    if (tagsFilter != null) {
        this.tagsFilter = new ArrayList();
        for (String item : tagsFilter) {
          this.addToTagsFilter(item);
        }
    } else {
      this.tagsFilter = null;
    }
    return (A) this;
  }
  
  public A withTagsFilter(java.lang.String... tagsFilter) {
    if (this.tagsFilter != null) {
        this.tagsFilter.clear();
        _visitables.remove("tagsFilter");
    }
    if (tagsFilter != null) {
      for (String item : tagsFilter) {
        this.addToTagsFilter(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTagsFilter() {
    return this.tagsFilter != null && !this.tagsFilter.isEmpty();
  }
  
  public SafeTLSConfig buildTlsConfig() {
    return this.tlsConfig != null ? this.tlsConfig.build() : null;
  }
  
  public A withTlsConfig(SafeTLSConfig tlsConfig) {
    this._visitables.remove("tlsConfig");
    if (tlsConfig != null) {
        this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
        this._visitables.get("tlsConfig").add(this.tlsConfig);
    } else {
        this.tlsConfig = null;
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  
  public TlsConfigNested<A> withNewTlsConfig() {
    return new TlsConfigNested(null);
  }
  
  public TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
    return new TlsConfigNested(item);
  }
  
  public TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(null));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(new SafeTLSConfigBuilder().build()));
  }
  
  public TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
    return withNewTlsConfigLike(java.util.Optional.ofNullable(buildTlsConfig()).orElse(item));
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ScalewaySDConfigFluent that = (ScalewaySDConfigFluent) o;
    if (!java.util.Objects.equals(accessKey, that.accessKey)) return false;
    if (!java.util.Objects.equals(apiURL, that.apiURL)) return false;
    if (!java.util.Objects.equals(enableHTTP2, that.enableHTTP2)) return false;
    if (!java.util.Objects.equals(followRedirects, that.followRedirects)) return false;
    if (!java.util.Objects.equals(nameFilter, that.nameFilter)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(projectID, that.projectID)) return false;
    if (!java.util.Objects.equals(proxyConnectHeader, that.proxyConnectHeader)) return false;
    if (!java.util.Objects.equals(proxyFromEnvironment, that.proxyFromEnvironment)) return false;
    if (!java.util.Objects.equals(proxyUrl, that.proxyUrl)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(role, that.role)) return false;
    if (!java.util.Objects.equals(secretKey, that.secretKey)) return false;
    if (!java.util.Objects.equals(tagsFilter, that.tagsFilter)) return false;
    if (!java.util.Objects.equals(tlsConfig, that.tlsConfig)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(accessKey,  apiURL,  enableHTTP2,  followRedirects,  nameFilter,  noProxy,  port,  projectID,  proxyConnectHeader,  proxyFromEnvironment,  proxyUrl,  refreshInterval,  role,  secretKey,  tagsFilter,  tlsConfig,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKey != null) { sb.append("accessKey:"); sb.append(accessKey + ","); }
    if (apiURL != null) { sb.append("apiURL:"); sb.append(apiURL + ","); }
    if (enableHTTP2 != null) { sb.append("enableHTTP2:"); sb.append(enableHTTP2 + ","); }
    if (followRedirects != null) { sb.append("followRedirects:"); sb.append(followRedirects + ","); }
    if (nameFilter != null) { sb.append("nameFilter:"); sb.append(nameFilter + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (projectID != null) { sb.append("projectID:"); sb.append(projectID + ","); }
    if (proxyConnectHeader != null && !proxyConnectHeader.isEmpty()) { sb.append("proxyConnectHeader:"); sb.append(proxyConnectHeader + ","); }
    if (proxyFromEnvironment != null) { sb.append("proxyFromEnvironment:"); sb.append(proxyFromEnvironment + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretKey != null) { sb.append("secretKey:"); sb.append(secretKey + ","); }
    if (tagsFilter != null && !tagsFilter.isEmpty()) { sb.append("tagsFilter:"); sb.append(tagsFilter + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnableHTTP2() {
    return withEnableHTTP2(true);
  }
  
  public A withFollowRedirects() {
    return withFollowRedirects(true);
  }
  
  public A withProxyFromEnvironment() {
    return withProxyFromEnvironment(true);
  }
  public class TlsConfigNested<N> extends SafeTLSConfigFluent<TlsConfigNested<N>> implements Nested<N>{
    TlsConfigNested(SafeTLSConfig item) {
      this.builder = new SafeTLSConfigBuilder(this, item);
    }
    SafeTLSConfigBuilder builder;
    
    public N and() {
      return (N) ScalewaySDConfigFluent.this.withTlsConfig(builder.build());
    }
    
    public N endTlsConfig() {
      return and();
    }
    
  
  }

}