package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PuppetDBSDConfigBuilder extends PuppetDBSDConfigFluent<PuppetDBSDConfigBuilder> implements VisitableBuilder<PuppetDBSDConfig,PuppetDBSDConfigBuilder>{
  public PuppetDBSDConfigBuilder() {
    this(new PuppetDBSDConfig());
  }
  
  public PuppetDBSDConfigBuilder(PuppetDBSDConfigFluent<?> fluent) {
    this(fluent, new PuppetDBSDConfig());
  }
  
  public PuppetDBSDConfigBuilder(PuppetDBSDConfigFluent<?> fluent,PuppetDBSDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PuppetDBSDConfigBuilder(PuppetDBSDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PuppetDBSDConfigFluent<?> fluent;
  
  public PuppetDBSDConfig build() {
    PuppetDBSDConfig buildable = new PuppetDBSDConfig(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getEnableHTTP2(),fluent.getFollowRedirects(),fluent.getIncludeParameters(),fluent.getNoProxy(),fluent.buildOauth2(),fluent.getPort(),fluent.getProxyConnectHeader(),fluent.getProxyFromEnvironment(),fluent.getProxyUrl(),fluent.getQuery(),fluent.getRefreshInterval(),fluent.buildTlsConfig(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}