package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureSDConfigFluent<A extends AzureSDConfigFluent<A>> extends BaseFluent<A>{
  public AzureSDConfigFluent() {
  }
  
  public AzureSDConfigFluent(AzureSDConfig instance) {
    this.copyInstance(instance);
  }
  private String authenticationMethod;
  private String clientID;
  private SecretKeySelector clientSecret;
  private String environment;
  private Integer port;
  private String refreshInterval;
  private String resourceGroup;
  private String subscriptionID;
  private String tenantID;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureSDConfig instance) {
    instance = (instance != null ? instance : new AzureSDConfig());
    if (instance != null) {
          this.withAuthenticationMethod(instance.getAuthenticationMethod());
          this.withClientID(instance.getClientID());
          this.withClientSecret(instance.getClientSecret());
          this.withEnvironment(instance.getEnvironment());
          this.withPort(instance.getPort());
          this.withRefreshInterval(instance.getRefreshInterval());
          this.withResourceGroup(instance.getResourceGroup());
          this.withSubscriptionID(instance.getSubscriptionID());
          this.withTenantID(instance.getTenantID());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAuthenticationMethod() {
    return this.authenticationMethod;
  }
  
  public A withAuthenticationMethod(String authenticationMethod) {
    this.authenticationMethod = authenticationMethod;
    return (A) this;
  }
  
  public boolean hasAuthenticationMethod() {
    return this.authenticationMethod != null;
  }
  
  public String getClientID() {
    return this.clientID;
  }
  
  public A withClientID(String clientID) {
    this.clientID = clientID;
    return (A) this;
  }
  
  public boolean hasClientID() {
    return this.clientID != null;
  }
  
  public SecretKeySelector getClientSecret() {
    return this.clientSecret;
  }
  
  public A withClientSecret(SecretKeySelector clientSecret) {
    this.clientSecret = clientSecret;
    return (A) this;
  }
  
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  
  public A withNewClientSecret(String key,String name,Boolean optional) {
    return (A)withClientSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getEnvironment() {
    return this.environment;
  }
  
  public A withEnvironment(String environment) {
    this.environment = environment;
    return (A) this;
  }
  
  public boolean hasEnvironment() {
    return this.environment != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getRefreshInterval() {
    return this.refreshInterval;
  }
  
  public A withRefreshInterval(String refreshInterval) {
    this.refreshInterval = refreshInterval;
    return (A) this;
  }
  
  public boolean hasRefreshInterval() {
    return this.refreshInterval != null;
  }
  
  public String getResourceGroup() {
    return this.resourceGroup;
  }
  
  public A withResourceGroup(String resourceGroup) {
    this.resourceGroup = resourceGroup;
    return (A) this;
  }
  
  public boolean hasResourceGroup() {
    return this.resourceGroup != null;
  }
  
  public String getSubscriptionID() {
    return this.subscriptionID;
  }
  
  public A withSubscriptionID(String subscriptionID) {
    this.subscriptionID = subscriptionID;
    return (A) this;
  }
  
  public boolean hasSubscriptionID() {
    return this.subscriptionID != null;
  }
  
  public String getTenantID() {
    return this.tenantID;
  }
  
  public A withTenantID(String tenantID) {
    this.tenantID = tenantID;
    return (A) this;
  }
  
  public boolean hasTenantID() {
    return this.tenantID != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureSDConfigFluent that = (AzureSDConfigFluent) o;
    if (!java.util.Objects.equals(authenticationMethod, that.authenticationMethod)) return false;
    if (!java.util.Objects.equals(clientID, that.clientID)) return false;
    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;
    if (!java.util.Objects.equals(environment, that.environment)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(refreshInterval, that.refreshInterval)) return false;
    if (!java.util.Objects.equals(resourceGroup, that.resourceGroup)) return false;
    if (!java.util.Objects.equals(subscriptionID, that.subscriptionID)) return false;
    if (!java.util.Objects.equals(tenantID, that.tenantID)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authenticationMethod,  clientID,  clientSecret,  environment,  port,  refreshInterval,  resourceGroup,  subscriptionID,  tenantID,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authenticationMethod != null) { sb.append("authenticationMethod:"); sb.append(authenticationMethod + ","); }
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (environment != null) { sb.append("environment:"); sb.append(environment + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (refreshInterval != null) { sb.append("refreshInterval:"); sb.append(refreshInterval + ","); }
    if (resourceGroup != null) { sb.append("resourceGroup:"); sb.append(resourceGroup + ","); }
    if (subscriptionID != null) { sb.append("subscriptionID:"); sb.append(subscriptionID + ","); }
    if (tenantID != null) { sb.append("tenantID:"); sb.append(tenantID + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}