package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureSDConfigBuilder extends AzureSDConfigFluent<AzureSDConfigBuilder> implements VisitableBuilder<AzureSDConfig,AzureSDConfigBuilder>{
  public AzureSDConfigBuilder() {
    this(new AzureSDConfig());
  }
  
  public AzureSDConfigBuilder(AzureSDConfigFluent<?> fluent) {
    this(fluent, new AzureSDConfig());
  }
  
  public AzureSDConfigBuilder(AzureSDConfigFluent<?> fluent,AzureSDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureSDConfigBuilder(AzureSDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureSDConfigFluent<?> fluent;
  
  public AzureSDConfig build() {
    AzureSDConfig buildable = new AzureSDConfig(fluent.getAuthenticationMethod(),fluent.getClientID(),fluent.getClientSecret(),fluent.getEnvironment(),fluent.getPort(),fluent.getRefreshInterval(),fluent.getResourceGroup(),fluent.getSubscriptionID(),fluent.getTenantID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}