package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ThanosSpecFluent<A extends ThanosSpecFluent<A>> extends BaseFluent<A>{
  public ThanosSpecFluent() {
  }
  
  public ThanosSpecFluent(ThanosSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ArgumentBuilder> additionalArgs = new ArrayList<ArgumentBuilder>();
  private String baseImage;
  private String blockSize;
  private String getConfigInterval;
  private String getConfigTimeout;
  private Boolean grpcListenLocal;
  private TLSConfigBuilder grpcServerTlsConfig;
  private Boolean httpListenLocal;
  private String image;
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private String minTime;
  private SecretKeySelector objectStorageConfig;
  private String objectStorageConfigFile;
  private String readyTimeout;
  private ResourceRequirementsBuilder resources;
  private String sha;
  private String tag;
  private SecretKeySelector tracingConfig;
  private String tracingConfigFile;
  private String version;
  private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList<VolumeMountBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ThanosSpec instance) {
    instance = (instance != null ? instance : new ThanosSpec());
    if (instance != null) {
          this.withAdditionalArgs(instance.getAdditionalArgs());
          this.withBaseImage(instance.getBaseImage());
          this.withBlockSize(instance.getBlockSize());
          this.withGetConfigInterval(instance.getGetConfigInterval());
          this.withGetConfigTimeout(instance.getGetConfigTimeout());
          this.withGrpcListenLocal(instance.getGrpcListenLocal());
          this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
          this.withHttpListenLocal(instance.getHttpListenLocal());
          this.withImage(instance.getImage());
          this.withListenLocal(instance.getListenLocal());
          this.withLogFormat(instance.getLogFormat());
          this.withLogLevel(instance.getLogLevel());
          this.withMinTime(instance.getMinTime());
          this.withObjectStorageConfig(instance.getObjectStorageConfig());
          this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
          this.withReadyTimeout(instance.getReadyTimeout());
          this.withResources(instance.getResources());
          this.withSha(instance.getSha());
          this.withTag(instance.getTag());
          this.withTracingConfig(instance.getTracingConfig());
          this.withTracingConfigFile(instance.getTracingConfigFile());
          this.withVersion(instance.getVersion());
          this.withVolumeMounts(instance.getVolumeMounts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalArgs(int index,Argument item) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    ArgumentBuilder builder = new ArgumentBuilder(item);
    if (index < 0 || index >= additionalArgs.size()) { _visitables.get("additionalArgs").add(builder); additionalArgs.add(builder); } else { _visitables.get("additionalArgs").add(index, builder); additionalArgs.add(index, builder);}
    return (A)this;
  }
  
  public A setToAdditionalArgs(int index,Argument item) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    ArgumentBuilder builder = new ArgumentBuilder(item);
    if (index < 0 || index >= additionalArgs.size()) { _visitables.get("additionalArgs").add(builder); additionalArgs.add(builder); } else { _visitables.get("additionalArgs").set(index, builder); additionalArgs.set(index, builder);}
    return (A)this;
  }
  
  public A addToAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... items) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").add(builder);this.additionalArgs.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalArgs(Collection<Argument> items) {
    if (this.additionalArgs == null) {this.additionalArgs = new ArrayList<ArgumentBuilder>();}
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").add(builder);this.additionalArgs.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... items) {
    if (this.additionalArgs == null) return (A)this;
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").remove(builder); this.additionalArgs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalArgs(Collection<Argument> items) {
    if (this.additionalArgs == null) return (A)this;
    for (Argument item : items) {ArgumentBuilder builder = new ArgumentBuilder(item);_visitables.get("additionalArgs").remove(builder); this.additionalArgs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalArgs(Predicate<ArgumentBuilder> predicate) {
    if (additionalArgs == null) return (A) this;
    final Iterator<ArgumentBuilder> each = additionalArgs.iterator();
    final List visitables = _visitables.get("additionalArgs");
    while (each.hasNext()) {
      ArgumentBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Argument> buildAdditionalArgs() {
    return this.additionalArgs != null ? build(additionalArgs) : null;
  }
  
  public Argument buildAdditionalArg(int index) {
    return this.additionalArgs.get(index).build();
  }
  
  public Argument buildFirstAdditionalArg() {
    return this.additionalArgs.get(0).build();
  }
  
  public Argument buildLastAdditionalArg() {
    return this.additionalArgs.get(additionalArgs.size() - 1).build();
  }
  
  public Argument buildMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
      for (ArgumentBuilder item : additionalArgs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
      for (ArgumentBuilder item : additionalArgs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalArgs(List<Argument> additionalArgs) {
    if (this.additionalArgs != null) {
      this._visitables.get("additionalArgs").clear();
    }
    if (additionalArgs != null) {
        this.additionalArgs = new ArrayList();
        for (Argument item : additionalArgs) {
          this.addToAdditionalArgs(item);
        }
    } else {
      this.additionalArgs = null;
    }
    return (A) this;
  }
  
  public A withAdditionalArgs(io.fabric8.openshift.api.model.monitoring.v1.Argument... additionalArgs) {
    if (this.additionalArgs != null) {
        this.additionalArgs.clear();
        _visitables.remove("additionalArgs");
    }
    if (additionalArgs != null) {
      for (Argument item : additionalArgs) {
        this.addToAdditionalArgs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalArgs() {
    return this.additionalArgs != null && !this.additionalArgs.isEmpty();
  }
  
  public A addNewAdditionalArg(String name,String value) {
    return (A)addToAdditionalArgs(new Argument(name, value));
  }
  
  public AdditionalArgsNested<A> addNewAdditionalArg() {
    return new AdditionalArgsNested(-1, null);
  }
  
  public AdditionalArgsNested<A> addNewAdditionalArgLike(Argument item) {
    return new AdditionalArgsNested(-1, item);
  }
  
  public AdditionalArgsNested<A> setNewAdditionalArgLike(int index,Argument item) {
    return new AdditionalArgsNested(index, item);
  }
  
  public AdditionalArgsNested<A> editAdditionalArg(int index) {
    if (additionalArgs.size() <= index) throw new RuntimeException("Can't edit additionalArgs. Index exceeds size.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public AdditionalArgsNested<A> editFirstAdditionalArg() {
    if (additionalArgs.size() == 0) throw new RuntimeException("Can't edit first additionalArgs. The list is empty.");
    return setNewAdditionalArgLike(0, buildAdditionalArg(0));
  }
  
  public AdditionalArgsNested<A> editLastAdditionalArg() {
    int index = additionalArgs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalArgs. The list is empty.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public AdditionalArgsNested<A> editMatchingAdditionalArg(Predicate<ArgumentBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalArgs.size();i++) { 
    if (predicate.test(additionalArgs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalArgs. No match found.");
    return setNewAdditionalArgLike(index, buildAdditionalArg(index));
  }
  
  public String getBaseImage() {
    return this.baseImage;
  }
  
  public A withBaseImage(String baseImage) {
    this.baseImage = baseImage;
    return (A) this;
  }
  
  public boolean hasBaseImage() {
    return this.baseImage != null;
  }
  
  public String getBlockSize() {
    return this.blockSize;
  }
  
  public A withBlockSize(String blockSize) {
    this.blockSize = blockSize;
    return (A) this;
  }
  
  public boolean hasBlockSize() {
    return this.blockSize != null;
  }
  
  public String getGetConfigInterval() {
    return this.getConfigInterval;
  }
  
  public A withGetConfigInterval(String getConfigInterval) {
    this.getConfigInterval = getConfigInterval;
    return (A) this;
  }
  
  public boolean hasGetConfigInterval() {
    return this.getConfigInterval != null;
  }
  
  public String getGetConfigTimeout() {
    return this.getConfigTimeout;
  }
  
  public A withGetConfigTimeout(String getConfigTimeout) {
    this.getConfigTimeout = getConfigTimeout;
    return (A) this;
  }
  
  public boolean hasGetConfigTimeout() {
    return this.getConfigTimeout != null;
  }
  
  public Boolean getGrpcListenLocal() {
    return this.grpcListenLocal;
  }
  
  public A withGrpcListenLocal(Boolean grpcListenLocal) {
    this.grpcListenLocal = grpcListenLocal;
    return (A) this;
  }
  
  public boolean hasGrpcListenLocal() {
    return this.grpcListenLocal != null;
  }
  
  public TLSConfig buildGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null ? this.grpcServerTlsConfig.build() : null;
  }
  
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
    this._visitables.remove("grpcServerTlsConfig");
    if (grpcServerTlsConfig != null) {
        this.grpcServerTlsConfig = new TLSConfigBuilder(grpcServerTlsConfig);
        this._visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);
    } else {
        this.grpcServerTlsConfig = null;
        this._visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
    }
    return (A) this;
  }
  
  public boolean hasGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null;
  }
  
  public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
    return new GrpcServerTlsConfigNested(null);
  }
  
  public GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
    return new GrpcServerTlsConfigNested(item);
  }
  
  public GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(null));
  }
  
  public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(new TLSConfigBuilder().build()));
  }
  
  public GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
    return withNewGrpcServerTlsConfigLike(java.util.Optional.ofNullable(buildGrpcServerTlsConfig()).orElse(item));
  }
  
  public Boolean getHttpListenLocal() {
    return this.httpListenLocal;
  }
  
  public A withHttpListenLocal(Boolean httpListenLocal) {
    this.httpListenLocal = httpListenLocal;
    return (A) this;
  }
  
  public boolean hasHttpListenLocal() {
    return this.httpListenLocal != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal = listenLocal;
    return (A) this;
  }
  
  public boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  
  public String getLogFormat() {
    return this.logFormat;
  }
  
  public A withLogFormat(String logFormat) {
    this.logFormat = logFormat;
    return (A) this;
  }
  
  public boolean hasLogFormat() {
    return this.logFormat != null;
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public String getMinTime() {
    return this.minTime;
  }
  
  public A withMinTime(String minTime) {
    this.minTime = minTime;
    return (A) this;
  }
  
  public boolean hasMinTime() {
    return this.minTime != null;
  }
  
  public SecretKeySelector getObjectStorageConfig() {
    return this.objectStorageConfig;
  }
  
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
    this.objectStorageConfig = objectStorageConfig;
    return (A) this;
  }
  
  public boolean hasObjectStorageConfig() {
    return this.objectStorageConfig != null;
  }
  
  public A withNewObjectStorageConfig(String key,String name,Boolean optional) {
    return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
  }
  
  public String getObjectStorageConfigFile() {
    return this.objectStorageConfigFile;
  }
  
  public A withObjectStorageConfigFile(String objectStorageConfigFile) {
    this.objectStorageConfigFile = objectStorageConfigFile;
    return (A) this;
  }
  
  public boolean hasObjectStorageConfigFile() {
    return this.objectStorageConfigFile != null;
  }
  
  public String getReadyTimeout() {
    return this.readyTimeout;
  }
  
  public A withReadyTimeout(String readyTimeout) {
    this.readyTimeout = readyTimeout;
    return (A) this;
  }
  
  public boolean hasReadyTimeout() {
    return this.readyTimeout != null;
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public String getSha() {
    return this.sha;
  }
  
  public A withSha(String sha) {
    this.sha = sha;
    return (A) this;
  }
  
  public boolean hasSha() {
    return this.sha != null;
  }
  
  public String getTag() {
    return this.tag;
  }
  
  public A withTag(String tag) {
    this.tag = tag;
    return (A) this;
  }
  
  public boolean hasTag() {
    return this.tag != null;
  }
  
  public SecretKeySelector getTracingConfig() {
    return this.tracingConfig;
  }
  
  public A withTracingConfig(SecretKeySelector tracingConfig) {
    this.tracingConfig = tracingConfig;
    return (A) this;
  }
  
  public boolean hasTracingConfig() {
    return this.tracingConfig != null;
  }
  
  public A withNewTracingConfig(String key,String name,Boolean optional) {
    return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
  }
  
  public String getTracingConfigFile() {
    return this.tracingConfigFile;
  }
  
  public A withTracingConfigFile(String tracingConfigFile) {
    this.tracingConfigFile = tracingConfigFile;
    return (A) this;
  }
  
  public boolean hasTracingConfigFile() {
    return this.tracingConfigFile != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").add(index, builder); volumeMounts.add(index, builder);}
    return (A)this;
  }
  
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    VolumeMountBuilder builder = new VolumeMountBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").set(index, builder); volumeMounts.set(index, builder);}
    return (A)this;
  }
  
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
    if (volumeMounts == null) return (A) this;
    final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
    final List visitables = _visitables.get("volumeMounts");
    while (each.hasNext()) {
      VolumeMountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VolumeMount> buildVolumeMounts() {
    return this.volumeMounts != null ? build(volumeMounts) : null;
  }
  
  public VolumeMount buildVolumeMount(int index) {
    return this.volumeMounts.get(index).build();
  }
  
  public VolumeMount buildFirstVolumeMount() {
    return this.volumeMounts.get(0).build();
  }
  
  public VolumeMount buildLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1).build();
  }
  
  public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
      for (VolumeMountBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
      for (VolumeMountBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (this.volumeMounts != null) {
      this._visitables.get("volumeMounts").clear();
    }
    if (volumeMounts != null) {
        this.volumeMounts = new ArrayList();
        for (VolumeMount item : volumeMounts) {
          this.addToVolumeMounts(item);
        }
    } else {
      this.volumeMounts = null;
    }
    return (A) this;
  }
  
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {
        this.volumeMounts.clear();
        _visitables.remove("volumeMounts");
    }
    if (volumeMounts != null) {
      for (VolumeMount item : volumeMounts) {
        this.addToVolumeMounts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumeMounts() {
    return this.volumeMounts != null && !this.volumeMounts.isEmpty();
  }
  
  public VolumeMountsNested<A> addNewVolumeMount() {
    return new VolumeMountsNested(-1, null);
  }
  
  public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
    return new VolumeMountsNested(-1, item);
  }
  
  public VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item) {
    return new VolumeMountsNested(index, item);
  }
  
  public VolumeMountsNested<A> editVolumeMount(int index) {
    if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editFirstVolumeMount() {
    if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
    return setNewVolumeMountLike(0, buildVolumeMount(0));
  }
  
  public VolumeMountsNested<A> editLastVolumeMount() {
    int index = volumeMounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeMounts.size();i++) { 
    if (predicate.test(volumeMounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosSpecFluent that = (ThanosSpecFluent) o;
    if (!java.util.Objects.equals(additionalArgs, that.additionalArgs)) return false;
    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;
    if (!java.util.Objects.equals(blockSize, that.blockSize)) return false;
    if (!java.util.Objects.equals(getConfigInterval, that.getConfigInterval)) return false;
    if (!java.util.Objects.equals(getConfigTimeout, that.getConfigTimeout)) return false;
    if (!java.util.Objects.equals(grpcListenLocal, that.grpcListenLocal)) return false;
    if (!java.util.Objects.equals(grpcServerTlsConfig, that.grpcServerTlsConfig)) return false;
    if (!java.util.Objects.equals(httpListenLocal, that.httpListenLocal)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(listenLocal, that.listenLocal)) return false;
    if (!java.util.Objects.equals(logFormat, that.logFormat)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(minTime, that.minTime)) return false;
    if (!java.util.Objects.equals(objectStorageConfig, that.objectStorageConfig)) return false;
    if (!java.util.Objects.equals(objectStorageConfigFile, that.objectStorageConfigFile)) return false;
    if (!java.util.Objects.equals(readyTimeout, that.readyTimeout)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(sha, that.sha)) return false;
    if (!java.util.Objects.equals(tag, that.tag)) return false;
    if (!java.util.Objects.equals(tracingConfig, that.tracingConfig)) return false;
    if (!java.util.Objects.equals(tracingConfigFile, that.tracingConfigFile)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalArgs,  baseImage,  blockSize,  getConfigInterval,  getConfigTimeout,  grpcListenLocal,  grpcServerTlsConfig,  httpListenLocal,  image,  listenLocal,  logFormat,  logLevel,  minTime,  objectStorageConfig,  objectStorageConfigFile,  readyTimeout,  resources,  sha,  tag,  tracingConfig,  tracingConfigFile,  version,  volumeMounts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalArgs != null && !additionalArgs.isEmpty()) { sb.append("additionalArgs:"); sb.append(additionalArgs + ","); }
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (blockSize != null) { sb.append("blockSize:"); sb.append(blockSize + ","); }
    if (getConfigInterval != null) { sb.append("getConfigInterval:"); sb.append(getConfigInterval + ","); }
    if (getConfigTimeout != null) { sb.append("getConfigTimeout:"); sb.append(getConfigTimeout + ","); }
    if (grpcListenLocal != null) { sb.append("grpcListenLocal:"); sb.append(grpcListenLocal + ","); }
    if (grpcServerTlsConfig != null) { sb.append("grpcServerTlsConfig:"); sb.append(grpcServerTlsConfig + ","); }
    if (httpListenLocal != null) { sb.append("httpListenLocal:"); sb.append(httpListenLocal + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minTime != null) { sb.append("minTime:"); sb.append(minTime + ","); }
    if (objectStorageConfig != null) { sb.append("objectStorageConfig:"); sb.append(objectStorageConfig + ","); }
    if (objectStorageConfigFile != null) { sb.append("objectStorageConfigFile:"); sb.append(objectStorageConfigFile + ","); }
    if (readyTimeout != null) { sb.append("readyTimeout:"); sb.append(readyTimeout + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (sha != null) { sb.append("sha:"); sb.append(sha + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (tracingConfig != null) { sb.append("tracingConfig:"); sb.append(tracingConfig + ","); }
    if (tracingConfigFile != null) { sb.append("tracingConfigFile:"); sb.append(tracingConfigFile + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withGrpcListenLocal() {
    return withGrpcListenLocal(true);
  }
  
  public A withHttpListenLocal() {
    return withHttpListenLocal(true);
  }
  
  public A withListenLocal() {
    return withListenLocal(true);
  }
  public class AdditionalArgsNested<N> extends ArgumentFluent<AdditionalArgsNested<N>> implements Nested<N>{
    AdditionalArgsNested(int index,Argument item) {
      this.index = index;
      this.builder = new ArgumentBuilder(this, item);
    }
    ArgumentBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosSpecFluent.this.setToAdditionalArgs(index,builder.build());
    }
    
    public N endAdditionalArg() {
      return and();
    }
    
  
  }
  public class GrpcServerTlsConfigNested<N> extends TLSConfigFluent<GrpcServerTlsConfigNested<N>> implements Nested<N>{
    GrpcServerTlsConfigNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    
    public N and() {
      return (N) ThanosSpecFluent.this.withGrpcServerTlsConfig(builder.build());
    }
    
    public N endGrpcServerTlsConfig() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ThanosSpecFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class VolumeMountsNested<N> extends VolumeMountFluent<VolumeMountsNested<N>> implements Nested<N>{
    VolumeMountsNested(int index,VolumeMount item) {
      this.index = index;
      this.builder = new VolumeMountBuilder(this, item);
    }
    VolumeMountBuilder builder;
    int index;
    
    public N and() {
      return (N) ThanosSpecFluent.this.setToVolumeMounts(index,builder.build());
    }
    
    public N endVolumeMount() {
      return and();
    }
    
  
  }

}