package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RuntimeConfigBuilder extends RuntimeConfigFluent<RuntimeConfigBuilder> implements VisitableBuilder<RuntimeConfig,RuntimeConfigBuilder>{
  public RuntimeConfigBuilder() {
    this(new RuntimeConfig());
  }
  
  public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent) {
    this(fluent, new RuntimeConfig());
  }
  
  public RuntimeConfigBuilder(RuntimeConfigFluent<?> fluent,RuntimeConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RuntimeConfigBuilder(RuntimeConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RuntimeConfigFluent<?> fluent;
  
  public RuntimeConfig build() {
    RuntimeConfig buildable = new RuntimeConfig(fluent.getGoGC());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}