package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodMetricsEndpointBuilder extends PodMetricsEndpointFluent<PodMetricsEndpointBuilder> implements VisitableBuilder<PodMetricsEndpoint,PodMetricsEndpointBuilder>{
  public PodMetricsEndpointBuilder() {
    this(new PodMetricsEndpoint());
  }
  
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent) {
    this(fluent, new PodMetricsEndpoint());
  }
  
  public PodMetricsEndpointBuilder(PodMetricsEndpointFluent<?> fluent,PodMetricsEndpoint instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodMetricsEndpointBuilder(PodMetricsEndpoint instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodMetricsEndpointFluent<?> fluent;
  
  public PodMetricsEndpoint build() {
    PodMetricsEndpoint buildable = new PodMetricsEndpoint(fluent.buildAuthorization(),fluent.buildBasicAuth(),fluent.getBearerTokenSecret(),fluent.getEnableHttp2(),fluent.getFilterRunning(),fluent.getFollowRedirects(),fluent.getHonorLabels(),fluent.getHonorTimestamps(),fluent.getInterval(),fluent.buildMetricRelabelings(),fluent.buildOauth2(),fluent.getParams(),fluent.getPath(),fluent.getPort(),fluent.getPortNumber(),fluent.getProxyUrl(),fluent.buildRelabelings(),fluent.getScheme(),fluent.getScrapeTimeout(),fluent.buildTargetPort(),fluent.buildTlsConfig(),fluent.getTrackTimestampsStaleness());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}