package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodDNSConfigBuilder extends PodDNSConfigFluent<PodDNSConfigBuilder> implements VisitableBuilder<PodDNSConfig,PodDNSConfigBuilder>{
  public PodDNSConfigBuilder() {
    this(new PodDNSConfig());
  }
  
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent) {
    this(fluent, new PodDNSConfig());
  }
  
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,PodDNSConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodDNSConfigBuilder(PodDNSConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodDNSConfigFluent<?> fluent;
  
  public PodDNSConfig build() {
    PodDNSConfig buildable = new PodDNSConfig(fluent.getNameservers(),fluent.buildOptions(),fluent.getSearches());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}