package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HostAliasBuilder extends HostAliasFluent<HostAliasBuilder> implements VisitableBuilder<HostAlias,HostAliasBuilder>{
  public HostAliasBuilder() {
    this(new HostAlias());
  }
  
  public HostAliasBuilder(HostAliasFluent<?> fluent) {
    this(fluent, new HostAlias());
  }
  
  public HostAliasBuilder(HostAliasFluent<?> fluent,HostAlias instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HostAliasBuilder(HostAlias instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HostAliasFluent<?> fluent;
  
  public HostAlias build() {
    HostAlias buildable = new HostAlias(fluent.getHostnames(),fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}