package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzureOAuthFluent<A extends AzureOAuthFluent<A>> extends BaseFluent<A>{
  public AzureOAuthFluent() {
  }
  
  public AzureOAuthFluent(AzureOAuth instance) {
    this.copyInstance(instance);
  }
  private String clientId;
  private SecretKeySelector clientSecret;
  private String tenantId;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzureOAuth instance) {
    instance = (instance != null ? instance : new AzureOAuth());
    if (instance != null) {
          this.withClientId(instance.getClientId());
          this.withClientSecret(instance.getClientSecret());
          this.withTenantId(instance.getTenantId());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientId() {
    return this.clientId;
  }
  
  public A withClientId(String clientId) {
    this.clientId = clientId;
    return (A) this;
  }
  
  public boolean hasClientId() {
    return this.clientId != null;
  }
  
  public SecretKeySelector getClientSecret() {
    return this.clientSecret;
  }
  
  public A withClientSecret(SecretKeySelector clientSecret) {
    this.clientSecret = clientSecret;
    return (A) this;
  }
  
  public boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  
  public A withNewClientSecret(String key,String name,Boolean optional) {
    return (A)withClientSecret(new SecretKeySelector(key, name, optional));
  }
  
  public String getTenantId() {
    return this.tenantId;
  }
  
  public A withTenantId(String tenantId) {
    this.tenantId = tenantId;
    return (A) this;
  }
  
  public boolean hasTenantId() {
    return this.tenantId != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzureOAuthFluent that = (AzureOAuthFluent) o;
    if (!java.util.Objects.equals(clientId, that.clientId)) return false;
    if (!java.util.Objects.equals(clientSecret, that.clientSecret)) return false;
    if (!java.util.Objects.equals(tenantId, that.tenantId)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientId,  clientSecret,  tenantId,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (tenantId != null) { sb.append("tenantId:"); sb.append(tenantId + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}