package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertmanagerGlobalConfigFluent<A extends AlertmanagerGlobalConfigFluent<A>> extends BaseFluent<A>{
  public AlertmanagerGlobalConfigFluent() {
  }
  
  public AlertmanagerGlobalConfigFluent(AlertmanagerGlobalConfig instance) {
    this.copyInstance(instance);
  }
  private HTTPConfigBuilder httpConfig;
  private SecretKeySelector opsGenieApiKey;
  private SecretKeySelector opsGenieApiUrl;
  private String pagerdutyUrl;
  private String resolveTimeout;
  private SecretKeySelector slackApiUrl;
  private GlobalSMTPConfigBuilder smtp;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertmanagerGlobalConfig instance) {
    instance = (instance != null ? instance : new AlertmanagerGlobalConfig());
    if (instance != null) {
          this.withHttpConfig(instance.getHttpConfig());
          this.withOpsGenieApiKey(instance.getOpsGenieApiKey());
          this.withOpsGenieApiUrl(instance.getOpsGenieApiUrl());
          this.withPagerdutyUrl(instance.getPagerdutyUrl());
          this.withResolveTimeout(instance.getResolveTimeout());
          this.withSlackApiUrl(instance.getSlackApiUrl());
          this.withSmtp(instance.getSmtp());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig != null ? this.httpConfig.build() : null;
  }
  
  public A withHttpConfig(HTTPConfig httpConfig) {
    this._visitables.remove("httpConfig");
    if (httpConfig != null) {
        this.httpConfig = new HTTPConfigBuilder(httpConfig);
        this._visitables.get("httpConfig").add(this.httpConfig);
    } else {
        this.httpConfig = null;
        this._visitables.get("httpConfig").remove(this.httpConfig);
    }
    return (A) this;
  }
  
  public boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  
  public HttpConfigNested<A> withNewHttpConfig() {
    return new HttpConfigNested(null);
  }
  
  public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new HttpConfigNested(item);
  }
  
  public HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(null));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
  }
  
  public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(java.util.Optional.ofNullable(buildHttpConfig()).orElse(item));
  }
  
  public SecretKeySelector getOpsGenieApiKey() {
    return this.opsGenieApiKey;
  }
  
  public A withOpsGenieApiKey(SecretKeySelector opsGenieApiKey) {
    this.opsGenieApiKey = opsGenieApiKey;
    return (A) this;
  }
  
  public boolean hasOpsGenieApiKey() {
    return this.opsGenieApiKey != null;
  }
  
  public A withNewOpsGenieApiKey(String key,String name,Boolean optional) {
    return (A)withOpsGenieApiKey(new SecretKeySelector(key, name, optional));
  }
  
  public SecretKeySelector getOpsGenieApiUrl() {
    return this.opsGenieApiUrl;
  }
  
  public A withOpsGenieApiUrl(SecretKeySelector opsGenieApiUrl) {
    this.opsGenieApiUrl = opsGenieApiUrl;
    return (A) this;
  }
  
  public boolean hasOpsGenieApiUrl() {
    return this.opsGenieApiUrl != null;
  }
  
  public A withNewOpsGenieApiUrl(String key,String name,Boolean optional) {
    return (A)withOpsGenieApiUrl(new SecretKeySelector(key, name, optional));
  }
  
  public String getPagerdutyUrl() {
    return this.pagerdutyUrl;
  }
  
  public A withPagerdutyUrl(String pagerdutyUrl) {
    this.pagerdutyUrl = pagerdutyUrl;
    return (A) this;
  }
  
  public boolean hasPagerdutyUrl() {
    return this.pagerdutyUrl != null;
  }
  
  public String getResolveTimeout() {
    return this.resolveTimeout;
  }
  
  public A withResolveTimeout(String resolveTimeout) {
    this.resolveTimeout = resolveTimeout;
    return (A) this;
  }
  
  public boolean hasResolveTimeout() {
    return this.resolveTimeout != null;
  }
  
  public SecretKeySelector getSlackApiUrl() {
    return this.slackApiUrl;
  }
  
  public A withSlackApiUrl(SecretKeySelector slackApiUrl) {
    this.slackApiUrl = slackApiUrl;
    return (A) this;
  }
  
  public boolean hasSlackApiUrl() {
    return this.slackApiUrl != null;
  }
  
  public A withNewSlackApiUrl(String key,String name,Boolean optional) {
    return (A)withSlackApiUrl(new SecretKeySelector(key, name, optional));
  }
  
  public GlobalSMTPConfig buildSmtp() {
    return this.smtp != null ? this.smtp.build() : null;
  }
  
  public A withSmtp(GlobalSMTPConfig smtp) {
    this._visitables.remove("smtp");
    if (smtp != null) {
        this.smtp = new GlobalSMTPConfigBuilder(smtp);
        this._visitables.get("smtp").add(this.smtp);
    } else {
        this.smtp = null;
        this._visitables.get("smtp").remove(this.smtp);
    }
    return (A) this;
  }
  
  public boolean hasSmtp() {
    return this.smtp != null;
  }
  
  public SmtpNested<A> withNewSmtp() {
    return new SmtpNested(null);
  }
  
  public SmtpNested<A> withNewSmtpLike(GlobalSMTPConfig item) {
    return new SmtpNested(item);
  }
  
  public SmtpNested<A> editSmtp() {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(null));
  }
  
  public SmtpNested<A> editOrNewSmtp() {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(new GlobalSMTPConfigBuilder().build()));
  }
  
  public SmtpNested<A> editOrNewSmtpLike(GlobalSMTPConfig item) {
    return withNewSmtpLike(java.util.Optional.ofNullable(buildSmtp()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertmanagerGlobalConfigFluent that = (AlertmanagerGlobalConfigFluent) o;
    if (!java.util.Objects.equals(httpConfig, that.httpConfig)) return false;
    if (!java.util.Objects.equals(opsGenieApiKey, that.opsGenieApiKey)) return false;
    if (!java.util.Objects.equals(opsGenieApiUrl, that.opsGenieApiUrl)) return false;
    if (!java.util.Objects.equals(pagerdutyUrl, that.pagerdutyUrl)) return false;
    if (!java.util.Objects.equals(resolveTimeout, that.resolveTimeout)) return false;
    if (!java.util.Objects.equals(slackApiUrl, that.slackApiUrl)) return false;
    if (!java.util.Objects.equals(smtp, that.smtp)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpConfig,  opsGenieApiKey,  opsGenieApiUrl,  pagerdutyUrl,  resolveTimeout,  slackApiUrl,  smtp,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (opsGenieApiKey != null) { sb.append("opsGenieApiKey:"); sb.append(opsGenieApiKey + ","); }
    if (opsGenieApiUrl != null) { sb.append("opsGenieApiUrl:"); sb.append(opsGenieApiUrl + ","); }
    if (pagerdutyUrl != null) { sb.append("pagerdutyUrl:"); sb.append(pagerdutyUrl + ","); }
    if (resolveTimeout != null) { sb.append("resolveTimeout:"); sb.append(resolveTimeout + ","); }
    if (slackApiUrl != null) { sb.append("slackApiUrl:"); sb.append(slackApiUrl + ","); }
    if (smtp != null) { sb.append("smtp:"); sb.append(smtp + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpConfigNested<N> extends HTTPConfigFluent<HttpConfigNested<N>> implements Nested<N>{
    HttpConfigNested(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HTTPConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withHttpConfig(builder.build());
    }
    
    public N endHttpConfig() {
      return and();
    }
    
  
  }
  public class SmtpNested<N> extends GlobalSMTPConfigFluent<SmtpNested<N>> implements Nested<N>{
    SmtpNested(GlobalSMTPConfig item) {
      this.builder = new GlobalSMTPConfigBuilder(this, item);
    }
    GlobalSMTPConfigBuilder builder;
    
    public N and() {
      return (N) AlertmanagerGlobalConfigFluent.this.withSmtp(builder.build());
    }
    
    public N endSmtp() {
      return and();
    }
    
  
  }

}