package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AlertingRuleStatusFluent<A extends AlertingRuleStatusFluent<A>> extends BaseFluent<A>{
  public AlertingRuleStatusFluent() {
  }
  
  public AlertingRuleStatusFluent(AlertingRuleStatus instance) {
    this.copyInstance(instance);
  }
  private Long observedGeneration;
  private PrometheusRuleRefBuilder prometheusRule;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AlertingRuleStatus instance) {
    instance = (instance != null ? instance : new AlertingRuleStatus());
    if (instance != null) {
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withPrometheusRule(instance.getPrometheusRule());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public PrometheusRuleRef buildPrometheusRule() {
    return this.prometheusRule != null ? this.prometheusRule.build() : null;
  }
  
  public A withPrometheusRule(PrometheusRuleRef prometheusRule) {
    this._visitables.remove("prometheusRule");
    if (prometheusRule != null) {
        this.prometheusRule = new PrometheusRuleRefBuilder(prometheusRule);
        this._visitables.get("prometheusRule").add(this.prometheusRule);
    } else {
        this.prometheusRule = null;
        this._visitables.get("prometheusRule").remove(this.prometheusRule);
    }
    return (A) this;
  }
  
  public boolean hasPrometheusRule() {
    return this.prometheusRule != null;
  }
  
  public A withNewPrometheusRule(String name) {
    return (A)withPrometheusRule(new PrometheusRuleRef(name));
  }
  
  public PrometheusRuleNested<A> withNewPrometheusRule() {
    return new PrometheusRuleNested(null);
  }
  
  public PrometheusRuleNested<A> withNewPrometheusRuleLike(PrometheusRuleRef item) {
    return new PrometheusRuleNested(item);
  }
  
  public PrometheusRuleNested<A> editPrometheusRule() {
    return withNewPrometheusRuleLike(java.util.Optional.ofNullable(buildPrometheusRule()).orElse(null));
  }
  
  public PrometheusRuleNested<A> editOrNewPrometheusRule() {
    return withNewPrometheusRuleLike(java.util.Optional.ofNullable(buildPrometheusRule()).orElse(new PrometheusRuleRefBuilder().build()));
  }
  
  public PrometheusRuleNested<A> editOrNewPrometheusRuleLike(PrometheusRuleRef item) {
    return withNewPrometheusRuleLike(java.util.Optional.ofNullable(buildPrometheusRule()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AlertingRuleStatusFluent that = (AlertingRuleStatusFluent) o;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(prometheusRule, that.prometheusRule)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(observedGeneration,  prometheusRule,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (prometheusRule != null) { sb.append("prometheusRule:"); sb.append(prometheusRule + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PrometheusRuleNested<N> extends PrometheusRuleRefFluent<PrometheusRuleNested<N>> implements Nested<N>{
    PrometheusRuleNested(PrometheusRuleRef item) {
      this.builder = new PrometheusRuleRefBuilder(this, item);
    }
    PrometheusRuleRefBuilder builder;
    
    public N and() {
      return (N) AlertingRuleStatusFluent.this.withPrometheusRule(builder.build());
    }
    
    public N endPrometheusRule() {
      return and();
    }
    
  
  }

}