package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InhibitRuleFluentImpl<A extends InhibitRuleFluent<A>> extends BaseFluent<A> implements InhibitRuleFluent<A>{
  public InhibitRuleFluentImpl() {
  }
  public InhibitRuleFluentImpl(InhibitRule instance) {
    if (instance != null) {
      this.withEqual(instance.getEqual());
      this.withSourceMatch(instance.getSourceMatch());
      this.withTargetMatch(instance.getTargetMatch());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> equal = new ArrayList<String>();
  private ArrayList<MatcherBuilder> sourceMatch = new ArrayList<MatcherBuilder>();
  private ArrayList<MatcherBuilder> targetMatch = new ArrayList<MatcherBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToEqual(int index,String item) {
    if (this.equal == null) {this.equal = new ArrayList<String>();}
    this.equal.add(index, item);
    return (A)this;
  }
  public A setToEqual(int index,String item) {
    if (this.equal == null) {this.equal = new ArrayList<String>();}
    this.equal.set(index, item); return (A)this;
  }
  public A addToEqual(java.lang.String... items) {
    if (this.equal == null) {this.equal = new ArrayList<String>();}
    for (String item : items) {this.equal.add(item);} return (A)this;
  }
  public A addAllToEqual(Collection<String> items) {
    if (this.equal == null) {this.equal = new ArrayList<String>();}
    for (String item : items) {this.equal.add(item);} return (A)this;
  }
  public A removeFromEqual(java.lang.String... items) {
    for (String item : items) {if (this.equal!= null){ this.equal.remove(item);}} return (A)this;
  }
  public A removeAllFromEqual(Collection<String> items) {
    for (String item : items) {if (this.equal!= null){ this.equal.remove(item);}} return (A)this;
  }
  public List<String> getEqual() {
    return this.equal;
  }
  public String getEqual(int index) {
    return this.equal.get(index);
  }
  public String getFirstEqual() {
    return this.equal.get(0);
  }
  public String getLastEqual() {
    return this.equal.get(equal.size() - 1);
  }
  public String getMatchingEqual(Predicate<String> predicate) {
    for (String item: equal) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEqual(Predicate<String> predicate) {
    for (String item: equal) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEqual(List<String> equal) {
    if (equal != null) {this.equal = new ArrayList(); for (String item : equal){this.addToEqual(item);}} else { this.equal = null;} return (A) this;
  }
  public A withEqual(java.lang.String... equal) {
    if (this.equal != null) {this.equal.clear(); _visitables.remove("equal"); }
    if (equal != null) {for (String item :equal){ this.addToEqual(item);}} return (A) this;
  }
  public Boolean hasEqual() {
    return equal != null && !equal.isEmpty();
  }
  public A addToSourceMatch(int index,Matcher item) {
    if (this.sourceMatch == null) {this.sourceMatch = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= sourceMatch.size()) { _visitables.get("sourceMatch").add(builder); sourceMatch.add(builder); } else { _visitables.get("sourceMatch").add(index, builder); sourceMatch.add(index, builder);}
    return (A)this;
  }
  public A setToSourceMatch(int index,Matcher item) {
    if (this.sourceMatch == null) {this.sourceMatch = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= sourceMatch.size()) { _visitables.get("sourceMatch").add(builder); sourceMatch.add(builder); } else { _visitables.get("sourceMatch").set(index, builder); sourceMatch.set(index, builder);}
    return (A)this;
  }
  public A addToSourceMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    if (this.sourceMatch == null) {this.sourceMatch = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("sourceMatch").add(builder);this.sourceMatch.add(builder);} return (A)this;
  }
  public A addAllToSourceMatch(Collection<Matcher> items) {
    if (this.sourceMatch == null) {this.sourceMatch = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("sourceMatch").add(builder);this.sourceMatch.add(builder);} return (A)this;
  }
  public A removeFromSourceMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("sourceMatch").remove(builder);if (this.sourceMatch != null) {this.sourceMatch.remove(builder);}} return (A)this;
  }
  public A removeAllFromSourceMatch(Collection<Matcher> items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("sourceMatch").remove(builder);if (this.sourceMatch != null) {this.sourceMatch.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSourceMatch(Predicate<MatcherBuilder> predicate) {
    if (sourceMatch == null) return (A) this;
    final Iterator<MatcherBuilder> each = sourceMatch.iterator();
    final List visitables = _visitables.get("sourceMatch");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSourceMatch instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Matcher> getSourceMatch() {
    return sourceMatch != null ? build(sourceMatch) : null;
  }
  public List<Matcher> buildSourceMatch() {
    return sourceMatch != null ? build(sourceMatch) : null;
  }
  public Matcher buildSourceMatch(int index) {
    return this.sourceMatch.get(index).build();
  }
  public Matcher buildFirstSourceMatch() {
    return this.sourceMatch.get(0).build();
  }
  public Matcher buildLastSourceMatch() {
    return this.sourceMatch.get(sourceMatch.size() - 1).build();
  }
  public Matcher buildMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: sourceMatch) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: sourceMatch) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSourceMatch(List<Matcher> sourceMatch) {
    if (this.sourceMatch != null) { _visitables.get("sourceMatch").clear();}
    if (sourceMatch != null) {this.sourceMatch = new ArrayList(); for (Matcher item : sourceMatch){this.addToSourceMatch(item);}} else { this.sourceMatch = null;} return (A) this;
  }
  public A withSourceMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... sourceMatch) {
    if (this.sourceMatch != null) {this.sourceMatch.clear(); _visitables.remove("sourceMatch"); }
    if (sourceMatch != null) {for (Matcher item :sourceMatch){ this.addToSourceMatch(item);}} return (A) this;
  }
  public Boolean hasSourceMatch() {
    return sourceMatch != null && !sourceMatch.isEmpty();
  }
  public A addNewSourceMatch(String name,Boolean regex,String value) {
    return (A)addToSourceMatch(new Matcher(name, regex, value));
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> addNewSourceMatch() {
    return new InhibitRuleFluentImpl.SourceMatchNestedImpl();
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> addNewSourceMatchLike(Matcher item) {
    return new InhibitRuleFluentImpl.SourceMatchNestedImpl(-1, item);
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> setNewSourceMatchLike(int index,Matcher item) {
    return new InhibitRuleFluentImpl.SourceMatchNestedImpl(index, item);
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> editSourceMatch(int index) {
    if (sourceMatch.size() <= index) throw new RuntimeException("Can't edit sourceMatch. Index exceeds size.");
    return setNewSourceMatchLike(index, buildSourceMatch(index));
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> editFirstSourceMatch() {
    if (sourceMatch.size() == 0) throw new RuntimeException("Can't edit first sourceMatch. The list is empty.");
    return setNewSourceMatchLike(0, buildSourceMatch(0));
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> editLastSourceMatch() {
    int index = sourceMatch.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sourceMatch. The list is empty.");
    return setNewSourceMatchLike(index, buildSourceMatch(index));
  }
  public InhibitRuleFluentImpl.SourceMatchNested<A> editMatchingSourceMatch(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sourceMatch.size();i++) { 
    if (predicate.test(sourceMatch.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sourceMatch. No match found.");
    return setNewSourceMatchLike(index, buildSourceMatch(index));
  }
  public A addToTargetMatch(int index,Matcher item) {
    if (this.targetMatch == null) {this.targetMatch = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= targetMatch.size()) { _visitables.get("targetMatch").add(builder); targetMatch.add(builder); } else { _visitables.get("targetMatch").add(index, builder); targetMatch.add(index, builder);}
    return (A)this;
  }
  public A setToTargetMatch(int index,Matcher item) {
    if (this.targetMatch == null) {this.targetMatch = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= targetMatch.size()) { _visitables.get("targetMatch").add(builder); targetMatch.add(builder); } else { _visitables.get("targetMatch").set(index, builder); targetMatch.set(index, builder);}
    return (A)this;
  }
  public A addToTargetMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    if (this.targetMatch == null) {this.targetMatch = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("targetMatch").add(builder);this.targetMatch.add(builder);} return (A)this;
  }
  public A addAllToTargetMatch(Collection<Matcher> items) {
    if (this.targetMatch == null) {this.targetMatch = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("targetMatch").add(builder);this.targetMatch.add(builder);} return (A)this;
  }
  public A removeFromTargetMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("targetMatch").remove(builder);if (this.targetMatch != null) {this.targetMatch.remove(builder);}} return (A)this;
  }
  public A removeAllFromTargetMatch(Collection<Matcher> items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("targetMatch").remove(builder);if (this.targetMatch != null) {this.targetMatch.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTargetMatch(Predicate<MatcherBuilder> predicate) {
    if (targetMatch == null) return (A) this;
    final Iterator<MatcherBuilder> each = targetMatch.iterator();
    final List visitables = _visitables.get("targetMatch");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetMatch instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Matcher> getTargetMatch() {
    return targetMatch != null ? build(targetMatch) : null;
  }
  public List<Matcher> buildTargetMatch() {
    return targetMatch != null ? build(targetMatch) : null;
  }
  public Matcher buildTargetMatch(int index) {
    return this.targetMatch.get(index).build();
  }
  public Matcher buildFirstTargetMatch() {
    return this.targetMatch.get(0).build();
  }
  public Matcher buildLastTargetMatch() {
    return this.targetMatch.get(targetMatch.size() - 1).build();
  }
  public Matcher buildMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: targetMatch) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: targetMatch) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTargetMatch(List<Matcher> targetMatch) {
    if (this.targetMatch != null) { _visitables.get("targetMatch").clear();}
    if (targetMatch != null) {this.targetMatch = new ArrayList(); for (Matcher item : targetMatch){this.addToTargetMatch(item);}} else { this.targetMatch = null;} return (A) this;
  }
  public A withTargetMatch(io.fabric8.openshift.api.model.monitoring.v1alpha1.Matcher... targetMatch) {
    if (this.targetMatch != null) {this.targetMatch.clear(); _visitables.remove("targetMatch"); }
    if (targetMatch != null) {for (Matcher item :targetMatch){ this.addToTargetMatch(item);}} return (A) this;
  }
  public Boolean hasTargetMatch() {
    return targetMatch != null && !targetMatch.isEmpty();
  }
  public A addNewTargetMatch(String name,Boolean regex,String value) {
    return (A)addToTargetMatch(new Matcher(name, regex, value));
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> addNewTargetMatch() {
    return new InhibitRuleFluentImpl.TargetMatchNestedImpl();
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> addNewTargetMatchLike(Matcher item) {
    return new InhibitRuleFluentImpl.TargetMatchNestedImpl(-1, item);
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> setNewTargetMatchLike(int index,Matcher item) {
    return new InhibitRuleFluentImpl.TargetMatchNestedImpl(index, item);
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> editTargetMatch(int index) {
    if (targetMatch.size() <= index) throw new RuntimeException("Can't edit targetMatch. Index exceeds size.");
    return setNewTargetMatchLike(index, buildTargetMatch(index));
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> editFirstTargetMatch() {
    if (targetMatch.size() == 0) throw new RuntimeException("Can't edit first targetMatch. The list is empty.");
    return setNewTargetMatchLike(0, buildTargetMatch(0));
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> editLastTargetMatch() {
    int index = targetMatch.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last targetMatch. The list is empty.");
    return setNewTargetMatchLike(index, buildTargetMatch(index));
  }
  public InhibitRuleFluentImpl.TargetMatchNested<A> editMatchingTargetMatch(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<targetMatch.size();i++) { 
    if (predicate.test(targetMatch.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching targetMatch. No match found.");
    return setNewTargetMatchLike(index, buildTargetMatch(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InhibitRuleFluentImpl that = (InhibitRuleFluentImpl) o;
    if (!java.util.Objects.equals(equal, that.equal)) return false;

    if (!java.util.Objects.equals(sourceMatch, that.sourceMatch)) return false;

    if (!java.util.Objects.equals(targetMatch, that.targetMatch)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(equal,  sourceMatch,  targetMatch,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (equal != null && !equal.isEmpty()) { sb.append("equal:"); sb.append(equal + ","); }
    if (sourceMatch != null && !sourceMatch.isEmpty()) { sb.append("sourceMatch:"); sb.append(sourceMatch + ","); }
    if (targetMatch != null && !targetMatch.isEmpty()) { sb.append("targetMatch:"); sb.append(targetMatch + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SourceMatchNestedImpl<N> extends MatcherFluentImpl<InhibitRuleFluentImpl.SourceMatchNested<N>> implements InhibitRuleFluentImpl.SourceMatchNested<N>,Nested<N>{
    SourceMatchNestedImpl(int index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    SourceMatchNestedImpl() {
      this.index = -1;
      this.builder = new MatcherBuilder(this);
    }
    MatcherBuilder builder;
    int index;
    public N and() {
      return (N) InhibitRuleFluentImpl.this.setToSourceMatch(index,builder.build());
    }
    public N endSourceMatch() {
      return and();
    }
    
  }
  class TargetMatchNestedImpl<N> extends MatcherFluentImpl<InhibitRuleFluentImpl.TargetMatchNested<N>> implements InhibitRuleFluentImpl.TargetMatchNested<N>,Nested<N>{
    TargetMatchNestedImpl(int index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    TargetMatchNestedImpl() {
      this.index = -1;
      this.builder = new MatcherBuilder(this);
    }
    MatcherBuilder builder;
    int index;
    public N and() {
      return (N) InhibitRuleFluentImpl.this.setToTargetMatch(index,builder.build());
    }
    public N endTargetMatch() {
      return and();
    }
    
  }
  
}