package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ThanosSpecFluentImpl<A extends ThanosSpecFluent<A>> extends BaseFluent<A> implements ThanosSpecFluent<A>{
  public ThanosSpecFluentImpl() {
  }
  public ThanosSpecFluentImpl(ThanosSpec instance) {
    if (instance != null) {
      this.withBaseImage(instance.getBaseImage());
      this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig());
      this.withImage(instance.getImage());
      this.withListenLocal(instance.getListenLocal());
      this.withLogFormat(instance.getLogFormat());
      this.withLogLevel(instance.getLogLevel());
      this.withMinTime(instance.getMinTime());
      this.withObjectStorageConfig(instance.getObjectStorageConfig());
      this.withObjectStorageConfigFile(instance.getObjectStorageConfigFile());
      this.withReadyTimeout(instance.getReadyTimeout());
      this.withResources(instance.getResources());
      this.withSha(instance.getSha());
      this.withTag(instance.getTag());
      this.withTracingConfig(instance.getTracingConfig());
      this.withTracingConfigFile(instance.getTracingConfigFile());
      this.withVersion(instance.getVersion());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String baseImage;
  private TLSConfigBuilder grpcServerTlsConfig;
  private String image;
  private Boolean listenLocal;
  private String logFormat;
  private String logLevel;
  private String minTime;
  private SecretKeySelector objectStorageConfig;
  private String objectStorageConfigFile;
  private String readyTimeout;
  private ResourceRequirementsBuilder resources;
  private String sha;
  private String tag;
  private SecretKeySelector tracingConfig;
  private String tracingConfigFile;
  private String version;
  private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
  private Map<String,Object> additionalProperties;
  public String getBaseImage() {
    return this.baseImage;
  }
  public A withBaseImage(String baseImage) {
    this.baseImage=baseImage; return (A) this;
  }
  public Boolean hasBaseImage() {
    return this.baseImage != null;
  }
  
  /**
   * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null ?this.grpcServerTlsConfig.build():null;
  }
  public TLSConfig buildGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig!=null ?this.grpcServerTlsConfig.build():null;
  }
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
    _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
    if (grpcServerTlsConfig!=null){ this.grpcServerTlsConfig= new TLSConfigBuilder(grpcServerTlsConfig); _visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);} else { this.grpcServerTlsConfig = null; _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig); } return (A) this;
  }
  public Boolean hasGrpcServerTlsConfig() {
    return this.grpcServerTlsConfig != null;
  }
  public ThanosSpecFluentImpl.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
    return new ThanosSpecFluentImpl.GrpcServerTlsConfigNestedImpl();
  }
  public ThanosSpecFluentImpl.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
    return new ThanosSpecFluentImpl.GrpcServerTlsConfigNestedImpl(item);
  }
  public ThanosSpecFluentImpl.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig());
  }
  public ThanosSpecFluentImpl.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): new TLSConfigBuilder().build());
  }
  public ThanosSpecFluentImpl.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
    return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): item);
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public Boolean getListenLocal() {
    return this.listenLocal;
  }
  public A withListenLocal(Boolean listenLocal) {
    this.listenLocal=listenLocal; return (A) this;
  }
  public Boolean hasListenLocal() {
    return this.listenLocal != null;
  }
  public String getLogFormat() {
    return this.logFormat;
  }
  public A withLogFormat(String logFormat) {
    this.logFormat=logFormat; return (A) this;
  }
  public Boolean hasLogFormat() {
    return this.logFormat != null;
  }
  public String getLogLevel() {
    return this.logLevel;
  }
  public A withLogLevel(String logLevel) {
    this.logLevel=logLevel; return (A) this;
  }
  public Boolean hasLogLevel() {
    return this.logLevel != null;
  }
  public String getMinTime() {
    return this.minTime;
  }
  public A withMinTime(String minTime) {
    this.minTime=minTime; return (A) this;
  }
  public Boolean hasMinTime() {
    return this.minTime != null;
  }
  public SecretKeySelector getObjectStorageConfig() {
    return this.objectStorageConfig;
  }
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
    this.objectStorageConfig=objectStorageConfig; return (A) this;
  }
  public Boolean hasObjectStorageConfig() {
    return this.objectStorageConfig != null;
  }
  public A withNewObjectStorageConfig(String key,String name,Boolean optional) {
    return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
  }
  public String getObjectStorageConfigFile() {
    return this.objectStorageConfigFile;
  }
  public A withObjectStorageConfigFile(String objectStorageConfigFile) {
    this.objectStorageConfigFile=objectStorageConfigFile; return (A) this;
  }
  public Boolean hasObjectStorageConfigFile() {
    return this.objectStorageConfigFile != null;
  }
  public String getReadyTimeout() {
    return this.readyTimeout;
  }
  public A withReadyTimeout(String readyTimeout) {
    this.readyTimeout=readyTimeout; return (A) this;
  }
  public Boolean hasReadyTimeout() {
    return this.readyTimeout != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public ThanosSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new ThanosSpecFluentImpl.ResourcesNestedImpl();
  }
  public ThanosSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ThanosSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public ThanosSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public ThanosSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public ThanosSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getSha() {
    return this.sha;
  }
  public A withSha(String sha) {
    this.sha=sha; return (A) this;
  }
  public Boolean hasSha() {
    return this.sha != null;
  }
  public String getTag() {
    return this.tag;
  }
  public A withTag(String tag) {
    this.tag=tag; return (A) this;
  }
  public Boolean hasTag() {
    return this.tag != null;
  }
  public SecretKeySelector getTracingConfig() {
    return this.tracingConfig;
  }
  public A withTracingConfig(SecretKeySelector tracingConfig) {
    this.tracingConfig=tracingConfig; return (A) this;
  }
  public Boolean hasTracingConfig() {
    return this.tracingConfig != null;
  }
  public A withNewTracingConfig(String key,String name,Boolean optional) {
    return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
  }
  public String getTracingConfigFile() {
    return this.tracingConfigFile;
  }
  public A withTracingConfigFile(String tracingConfigFile) {
    this.tracingConfigFile=tracingConfigFile; return (A) this;
  }
  public Boolean hasTracingConfigFile() {
    return this.tracingConfigFile != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.add(index, item);
    return (A)this;
  }
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.set(index, item); return (A)this;
  }
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
  }
  public List<VolumeMount> getVolumeMounts() {
    return this.volumeMounts;
  }
  public VolumeMount getVolumeMount(int index) {
    return this.volumeMounts.get(index);
  }
  public VolumeMount getFirstVolumeMount() {
    return this.volumeMounts.get(0);
  }
  public VolumeMount getLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1);
  }
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
    for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (volumeMounts != null) {this.volumeMounts = new ArrayList(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
  }
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear(); _visitables.remove("volumeMounts"); }
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  public Boolean hasVolumeMounts() {
    return volumeMounts != null && !volumeMounts.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosSpecFluentImpl that = (ThanosSpecFluentImpl) o;
    if (!java.util.Objects.equals(baseImage, that.baseImage)) return false;

    if (!java.util.Objects.equals(grpcServerTlsConfig, that.grpcServerTlsConfig)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(listenLocal, that.listenLocal)) return false;

    if (!java.util.Objects.equals(logFormat, that.logFormat)) return false;

    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;

    if (!java.util.Objects.equals(minTime, that.minTime)) return false;

    if (!java.util.Objects.equals(objectStorageConfig, that.objectStorageConfig)) return false;

    if (!java.util.Objects.equals(objectStorageConfigFile, that.objectStorageConfigFile)) return false;

    if (!java.util.Objects.equals(readyTimeout, that.readyTimeout)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(sha, that.sha)) return false;

    if (!java.util.Objects.equals(tag, that.tag)) return false;

    if (!java.util.Objects.equals(tracingConfig, that.tracingConfig)) return false;

    if (!java.util.Objects.equals(tracingConfigFile, that.tracingConfigFile)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseImage,  grpcServerTlsConfig,  image,  listenLocal,  logFormat,  logLevel,  minTime,  objectStorageConfig,  objectStorageConfigFile,  readyTimeout,  resources,  sha,  tag,  tracingConfig,  tracingConfigFile,  version,  volumeMounts,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseImage != null) { sb.append("baseImage:"); sb.append(baseImage + ","); }
    if (grpcServerTlsConfig != null) { sb.append("grpcServerTlsConfig:"); sb.append(grpcServerTlsConfig + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (listenLocal != null) { sb.append("listenLocal:"); sb.append(listenLocal + ","); }
    if (logFormat != null) { sb.append("logFormat:"); sb.append(logFormat + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (minTime != null) { sb.append("minTime:"); sb.append(minTime + ","); }
    if (objectStorageConfig != null) { sb.append("objectStorageConfig:"); sb.append(objectStorageConfig + ","); }
    if (objectStorageConfigFile != null) { sb.append("objectStorageConfigFile:"); sb.append(objectStorageConfigFile + ","); }
    if (readyTimeout != null) { sb.append("readyTimeout:"); sb.append(readyTimeout + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (sha != null) { sb.append("sha:"); sb.append(sha + ","); }
    if (tag != null) { sb.append("tag:"); sb.append(tag + ","); }
    if (tracingConfig != null) { sb.append("tracingConfig:"); sb.append(tracingConfig + ","); }
    if (tracingConfigFile != null) { sb.append("tracingConfigFile:"); sb.append(tracingConfigFile + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withListenLocal() {
    return withListenLocal(true);
  }
  class GrpcServerTlsConfigNestedImpl<N> extends TLSConfigFluentImpl<ThanosSpecFluentImpl.GrpcServerTlsConfigNested<N>> implements ThanosSpecFluentImpl.GrpcServerTlsConfigNested<N>,Nested<N>{
    GrpcServerTlsConfigNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    GrpcServerTlsConfigNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) ThanosSpecFluentImpl.this.withGrpcServerTlsConfig(builder.build());
    }
    public N endGrpcServerTlsConfig() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ThanosSpecFluentImpl.ResourcesNested<N>> implements ThanosSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) ThanosSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  
}