package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.Integer;

 /**
  * Generated
  */
public interface ThanosRulerSpecFluent<A extends ThanosRulerSpecFluent<A>> extends Fluent<A>{
  public Affinity getAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  public A addToAlertDropLabels(int index,String item);
  public A setToAlertDropLabels(int index,String item);
  public A addToAlertDropLabels(java.lang.String... items);
  public A addAllToAlertDropLabels(Collection<String> items);
  public A removeFromAlertDropLabels(java.lang.String... items);
  public A removeAllFromAlertDropLabels(Collection<String> items);
  public List<String> getAlertDropLabels();
  public String getAlertDropLabel(int index);
  public String getFirstAlertDropLabel();
  public String getLastAlertDropLabel();
  public String getMatchingAlertDropLabel(Predicate<String> predicate);
  public Boolean hasMatchingAlertDropLabel(Predicate<String> predicate);
  public A withAlertDropLabels(List<String> alertDropLabels);
  public A withAlertDropLabels(java.lang.String... alertDropLabels);
  public Boolean hasAlertDropLabels();
  public String getAlertQueryUrl();
  public A withAlertQueryUrl(String alertQueryUrl);
  public Boolean hasAlertQueryUrl();
  public String getAlertRelabelConfigFile();
  public A withAlertRelabelConfigFile(String alertRelabelConfigFile);
  public Boolean hasAlertRelabelConfigFile();
  public SecretKeySelector getAlertRelabelConfigs();
  public A withAlertRelabelConfigs(SecretKeySelector alertRelabelConfigs);
  public Boolean hasAlertRelabelConfigs();
  public A withNewAlertRelabelConfigs(String key,String name,Boolean optional);
  public SecretKeySelector getAlertmanagersConfig();
  public A withAlertmanagersConfig(SecretKeySelector alertmanagersConfig);
  public Boolean hasAlertmanagersConfig();
  public A withNewAlertmanagersConfig(String key,String name,Boolean optional);
  public A addToAlertmanagersUrl(int index,String item);
  public A setToAlertmanagersUrl(int index,String item);
  public A addToAlertmanagersUrl(java.lang.String... items);
  public A addAllToAlertmanagersUrl(Collection<String> items);
  public A removeFromAlertmanagersUrl(java.lang.String... items);
  public A removeAllFromAlertmanagersUrl(Collection<String> items);
  public List<String> getAlertmanagersUrl();
  public String getAlertmanagersUrl(int index);
  public String getFirstAlertmanagersUrl();
  public String getLastAlertmanagersUrl();
  public String getMatchingAlertmanagersUrl(Predicate<String> predicate);
  public Boolean hasMatchingAlertmanagersUrl(Predicate<String> predicate);
  public A withAlertmanagersUrl(List<String> alertmanagersUrl);
  public A withAlertmanagersUrl(java.lang.String... alertmanagersUrl);
  public Boolean hasAlertmanagersUrl();
  public A addToContainers(int index,Container item);
  public A setToContainers(int index,Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(Collection<Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers();
  public List<Container> buildContainers();
  public Container buildContainer(int index);
  public Container buildFirstContainer();
  public Container buildLastContainer();
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
  public A withContainers(List<Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public Boolean hasContainers();
  public ThanosRulerSpecFluent.ContainersNested<A> addNewContainer();
  public ThanosRulerSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
  public ThanosRulerSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
  public ThanosRulerSpecFluent.ContainersNested<A> editContainer(int index);
  public ThanosRulerSpecFluent.ContainersNested<A> editFirstContainer();
  public ThanosRulerSpecFluent.ContainersNested<A> editLastContainer();
  public ThanosRulerSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
  public String getEnforcedNamespaceLabel();
  public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel);
  public Boolean hasEnforcedNamespaceLabel();
  public String getEvaluationInterval();
  public A withEvaluationInterval(String evaluationInterval);
  public Boolean hasEvaluationInterval();
  public String getExternalPrefix();
  public A withExternalPrefix(String externalPrefix);
  public Boolean hasExternalPrefix();
  
  /**
   * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getGrpcServerTlsConfig();
  public TLSConfig buildGrpcServerTlsConfig();
  public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig);
  public Boolean hasGrpcServerTlsConfig();
  public ThanosRulerSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig();
  public ThanosRulerSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item);
  public ThanosRulerSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig();
  public ThanosRulerSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig();
  public ThanosRulerSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item);
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public A addToImagePullSecrets(int index,LocalObjectReference item);
  public A setToImagePullSecrets(int index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(int index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item);
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public ThanosRulerSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A addToInitContainers(int index,Container item);
  public A setToInitContainers(int index,Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers();
  public List<Container> buildInitContainers();
  public Container buildInitContainer(int index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A withInitContainers(List<Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public Boolean hasInitContainers();
  public ThanosRulerSpecFluent.InitContainersNested<A> addNewInitContainer();
  public ThanosRulerSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public ThanosRulerSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item);
  public ThanosRulerSpecFluent.InitContainersNested<A> editInitContainer(int index);
  public ThanosRulerSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public ThanosRulerSpecFluent.InitContainersNested<A> editLastInitContainer();
  public ThanosRulerSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A addToLabels(String key,String value);
  public A addToLabels(Map<String,String> map);
  public A removeFromLabels(String key);
  public A removeFromLabels(Map<String,String> map);
  public Map<String,String> getLabels();
  public <K,V>A withLabels(Map<String,String> labels);
  public Boolean hasLabels();
  public Boolean getListenLocal();
  public A withListenLocal(Boolean listenLocal);
  public Boolean hasListenLocal();
  public String getLogFormat();
  public A withLogFormat(String logFormat);
  public Boolean hasLogFormat();
  public String getLogLevel();
  public A withLogLevel(String logLevel);
  public Boolean hasLogLevel();
  public Integer getMinReadySeconds();
  public A withMinReadySeconds(Integer minReadySeconds);
  public Boolean hasMinReadySeconds();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  public SecretKeySelector getObjectStorageConfig();
  public A withObjectStorageConfig(SecretKeySelector objectStorageConfig);
  public Boolean hasObjectStorageConfig();
  public A withNewObjectStorageConfig(String key,String name,Boolean optional);
  public String getObjectStorageConfigFile();
  public A withObjectStorageConfigFile(String objectStorageConfigFile);
  public Boolean hasObjectStorageConfigFile();
  public Boolean getPaused();
  public A withPaused(Boolean paused);
  public Boolean hasPaused();
  
  /**
   * This method has been deprecated, please use method buildPodMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public EmbeddedObjectMetadata getPodMetadata();
  public EmbeddedObjectMetadata buildPodMetadata();
  public A withPodMetadata(EmbeddedObjectMetadata podMetadata);
  public Boolean hasPodMetadata();
  public ThanosRulerSpecFluent.PodMetadataNested<A> withNewPodMetadata();
  public ThanosRulerSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item);
  public ThanosRulerSpecFluent.PodMetadataNested<A> editPodMetadata();
  public ThanosRulerSpecFluent.PodMetadataNested<A> editOrNewPodMetadata();
  public ThanosRulerSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item);
  public String getPortName();
  public A withPortName(String portName);
  public Boolean hasPortName();
  public String getPriorityClassName();
  public A withPriorityClassName(String priorityClassName);
  public Boolean hasPriorityClassName();
  public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item);
  public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item);
  public A addToPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items);
  public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
  public A removeFromPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... items);
  public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items);
  public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce();
  public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index);
  public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce();
  public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce);
  public A withPrometheusRulesExcludedFromEnforce(io.fabric8.openshift.api.model.monitoring.v1.PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce);
  public Boolean hasPrometheusRulesExcludedFromEnforce();
  public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace);
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce();
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item);
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item);
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index);
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce();
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce();
  public ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate);
  public SecretKeySelector getQueryConfig();
  public A withQueryConfig(SecretKeySelector queryConfig);
  public Boolean hasQueryConfig();
  public A withNewQueryConfig(String key,String name,Boolean optional);
  public A addToQueryEndpoints(int index,String item);
  public A setToQueryEndpoints(int index,String item);
  public A addToQueryEndpoints(java.lang.String... items);
  public A addAllToQueryEndpoints(Collection<String> items);
  public A removeFromQueryEndpoints(java.lang.String... items);
  public A removeAllFromQueryEndpoints(Collection<String> items);
  public List<String> getQueryEndpoints();
  public String getQueryEndpoint(int index);
  public String getFirstQueryEndpoint();
  public String getLastQueryEndpoint();
  public String getMatchingQueryEndpoint(Predicate<String> predicate);
  public Boolean hasMatchingQueryEndpoint(Predicate<String> predicate);
  public A withQueryEndpoints(List<String> queryEndpoints);
  public A withQueryEndpoints(java.lang.String... queryEndpoints);
  public Boolean hasQueryEndpoints();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources();
  public ResourceRequirements buildResources();
  public A withResources(ResourceRequirements resources);
  public Boolean hasResources();
  public ThanosRulerSpecFluent.ResourcesNested<A> withNewResources();
  public ThanosRulerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
  public ThanosRulerSpecFluent.ResourcesNested<A> editResources();
  public ThanosRulerSpecFluent.ResourcesNested<A> editOrNewResources();
  public ThanosRulerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
  public String getRetention();
  public A withRetention(String retention);
  public Boolean hasRetention();
  public String getRoutePrefix();
  public A withRoutePrefix(String routePrefix);
  public Boolean hasRoutePrefix();
  
  /**
   * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleNamespaceSelector();
  public LabelSelector buildRuleNamespaceSelector();
  public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector);
  public Boolean hasRuleNamespaceSelector();
  public ThanosRulerSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector();
  public ThanosRulerSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item);
  public ThanosRulerSpecFluent.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector();
  public ThanosRulerSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector();
  public ThanosRulerSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildRuleSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getRuleSelector();
  public LabelSelector buildRuleSelector();
  public A withRuleSelector(LabelSelector ruleSelector);
  public Boolean hasRuleSelector();
  public ThanosRulerSpecFluent.RuleSelectorNested<A> withNewRuleSelector();
  public ThanosRulerSpecFluent.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item);
  public ThanosRulerSpecFluent.RuleSelectorNested<A> editRuleSelector();
  public ThanosRulerSpecFluent.RuleSelectorNested<A> editOrNewRuleSelector();
  public ThanosRulerSpecFluent.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item);
  public PodSecurityContext getSecurityContext();
  public A withSecurityContext(PodSecurityContext securityContext);
  public Boolean hasSecurityContext();
  public String getServiceAccountName();
  public A withServiceAccountName(String serviceAccountName);
  public Boolean hasServiceAccountName();
  
  /**
   * This method has been deprecated, please use method buildStorage instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageSpec getStorage();
  public StorageSpec buildStorage();
  public A withStorage(StorageSpec storage);
  public Boolean hasStorage();
  public ThanosRulerSpecFluent.StorageNested<A> withNewStorage();
  public ThanosRulerSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item);
  public ThanosRulerSpecFluent.StorageNested<A> editStorage();
  public ThanosRulerSpecFluent.StorageNested<A> editOrNewStorage();
  public ThanosRulerSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item);
  public A addToTolerations(int index,Toleration item);
  public A setToTolerations(int index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public List<Toleration> getTolerations();
  public Toleration getToleration(int index);
  public Toleration getFirstToleration();
  public Toleration getLastToleration();
  public Toleration getMatchingToleration(Predicate<Toleration> predicate);
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public A addToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(int index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public TopologySpreadConstraint getTopologySpreadConstraint(int index);
  public TopologySpreadConstraint getFirstTopologySpreadConstraint();
  public TopologySpreadConstraint getLastTopologySpreadConstraint();
  public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public SecretKeySelector getTracingConfig();
  public A withTracingConfig(SecretKeySelector tracingConfig);
  public Boolean hasTracingConfig();
  public A withNewTracingConfig(String key,String name,Boolean optional);
  public A addToVolumes(int index,Volume item);
  public A setToVolumes(int index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public List<Volume> getVolumes();
  public Volume getVolume(int index);
  public Volume getFirstVolume();
  public Volume getLastVolume();
  public Volume getMatchingVolume(Predicate<Volume> predicate);
  public Boolean hasMatchingVolume(Predicate<Volume> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withListenLocal();
  public A withPaused();
  public interface ContainersNested<N> extends Nested<N>,ContainerFluent<ThanosRulerSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface GrpcServerTlsConfigNested<N> extends Nested<N>,TLSConfigFluent<ThanosRulerSpecFluent.GrpcServerTlsConfigNested<N>>{
    public N and();
    public N endGrpcServerTlsConfig();
    
  }
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<ThanosRulerSpecFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<ThanosRulerSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface PodMetadataNested<N> extends Nested<N>,EmbeddedObjectMetadataFluent<ThanosRulerSpecFluent.PodMetadataNested<N>>{
    public N and();
    public N endPodMetadata();
    
  }
  public interface PrometheusRulesExcludedFromEnforceNested<N> extends Nested<N>,PrometheusRuleExcludeConfigFluent<ThanosRulerSpecFluent.PrometheusRulesExcludedFromEnforceNested<N>>{
    public N and();
    public N endPrometheusRulesExcludedFromEnforce();
    
  }
  public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ThanosRulerSpecFluent.ResourcesNested<N>>{
    public N and();
    public N endResources();
    
  }
  public interface RuleNamespaceSelectorNested<N> extends Nested<N>,LabelSelectorFluent<ThanosRulerSpecFluent.RuleNamespaceSelectorNested<N>>{
    public N and();
    public N endRuleNamespaceSelector();
    
  }
  public interface RuleSelectorNested<N> extends Nested<N>,LabelSelectorFluent<ThanosRulerSpecFluent.RuleSelectorNested<N>>{
    public N and();
    public N endRuleSelector();
    
  }
  public interface StorageNested<N> extends Nested<N>,StorageSpecFluent<ThanosRulerSpecFluent.StorageNested<N>>{
    public N and();
    public N endStorage();
    
  }
  
}