package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ThanosRulerListBuilder extends ThanosRulerListFluentImpl<ThanosRulerListBuilder> implements VisitableBuilder<ThanosRulerList,ThanosRulerListBuilder>{
  public ThanosRulerListBuilder() {
    this(false);
  }
  public ThanosRulerListBuilder(Boolean validationEnabled) {
    this(new ThanosRulerList(), validationEnabled);
  }
  public ThanosRulerListBuilder(ThanosRulerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerListBuilder(ThanosRulerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ThanosRulerList(), validationEnabled);
  }
  public ThanosRulerListBuilder(ThanosRulerListFluent<?> fluent,ThanosRulerList instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerListBuilder(ThanosRulerListFluent<?> fluent,ThanosRulerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerListBuilder(ThanosRulerList instance) {
    this(instance,false);
  }
  public ThanosRulerListBuilder(ThanosRulerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ThanosRulerListFluent<?> fluent;
  Boolean validationEnabled;
  public ThanosRulerList build() {
    ThanosRulerList buildable = new ThanosRulerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}