package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSConfigBuilder extends TLSConfigFluentImpl<TLSConfigBuilder> implements VisitableBuilder<TLSConfig,TLSConfigBuilder>{
  public TLSConfigBuilder() {
    this(false);
  }
  public TLSConfigBuilder(Boolean validationEnabled) {
    this(new TLSConfig(), validationEnabled);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSConfig(), validationEnabled);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,TLSConfig instance) {
    this(fluent, instance, false);
  }
  public TLSConfigBuilder(TLSConfigFluent<?> fluent,TLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withCaFile(instance.getCaFile());
      fluent.withCert(instance.getCert());
      fluent.withCertFile(instance.getCertFile());
      fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      fluent.withKeyFile(instance.getKeyFile());
      fluent.withKeySecret(instance.getKeySecret());
      fluent.withServerName(instance.getServerName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSConfigBuilder(TLSConfig instance) {
    this(instance,false);
  }
  public TLSConfigBuilder(TLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withCaFile(instance.getCaFile());
      this.withCert(instance.getCert());
      this.withCertFile(instance.getCertFile());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withKeyFile(instance.getKeyFile());
      this.withKeySecret(instance.getKeySecret());
      this.withServerName(instance.getServerName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public TLSConfig build() {
    TLSConfig buildable = new TLSConfig(fluent.getCa(),fluent.getCaFile(),fluent.getCert(),fluent.getCertFile(),fluent.getInsecureSkipVerify(),fluent.getKeyFile(),fluent.getKeySecret(),fluent.getServerName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}