package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretOrConfigMapBuilder extends SecretOrConfigMapFluentImpl<SecretOrConfigMapBuilder> implements VisitableBuilder<SecretOrConfigMap,SecretOrConfigMapBuilder>{
  public SecretOrConfigMapBuilder() {
    this(false);
  }
  public SecretOrConfigMapBuilder(Boolean validationEnabled) {
    this(new SecretOrConfigMap(), validationEnabled);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMapFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMapFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretOrConfigMap(), validationEnabled);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMapFluent<?> fluent,SecretOrConfigMap instance) {
    this(fluent, instance, false);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMapFluent<?> fluent,SecretOrConfigMap instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMap instance) {
    this(instance,false);
  }
  public SecretOrConfigMapBuilder(SecretOrConfigMap instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretOrConfigMapFluent<?> fluent;
  Boolean validationEnabled;
  public SecretOrConfigMap build() {
    SecretOrConfigMap buildable = new SecretOrConfigMap(fluent.getConfigMap(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}