package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebhookConfigFluentImpl<A extends WebhookConfigFluent<A>> extends BaseFluent<A> implements WebhookConfigFluent<A>{
  public WebhookConfigFluentImpl() {
  }
  public WebhookConfigFluentImpl(WebhookConfig instance) {
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMaxAlerts(instance.getMaxAlerts()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withUrl(instance.getUrl()); 
    this.withUrlSecret(instance.getUrlSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private HTTPConfigBuilder httpConfig;
  private Integer maxAlerts;
  private Boolean sendResolved;
  private String url;
  private SecretKeySelector urlSecret;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildHttpConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPConfig getHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public HTTPConfig buildHttpConfig() {
    return this.httpConfig!=null ?this.httpConfig.build():null;
  }
  public A withHttpConfig(HTTPConfig httpConfig) {
    _visitables.get("httpConfig").remove(this.httpConfig);
    if (httpConfig!=null){ this.httpConfig= new HTTPConfigBuilder(httpConfig); _visitables.get("httpConfig").add(this.httpConfig);} else { this.httpConfig = null; _visitables.get("httpConfig").remove(this.httpConfig); } return (A) this;
  }
  public Boolean hasHttpConfig() {
    return this.httpConfig != null;
  }
  public WebhookConfigFluent.HttpConfigNested<A> withNewHttpConfig() {
    return new WebhookConfigFluentImpl.HttpConfigNestedImpl();
  }
  public WebhookConfigFluent.HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
    return new WebhookConfigFluentImpl.HttpConfigNestedImpl(item);
  }
  public WebhookConfigFluent.HttpConfigNested<A> editHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig());
  }
  public WebhookConfigFluent.HttpConfigNested<A> editOrNewHttpConfig() {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): new HTTPConfigBuilder().build());
  }
  public WebhookConfigFluent.HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
    return withNewHttpConfigLike(getHttpConfig() != null ? getHttpConfig(): item);
  }
  public Integer getMaxAlerts() {
    return this.maxAlerts;
  }
  public A withMaxAlerts(Integer maxAlerts) {
    this.maxAlerts=maxAlerts; return (A) this;
  }
  public Boolean hasMaxAlerts() {
    return this.maxAlerts != null;
  }
  public Boolean getSendResolved() {
    return this.sendResolved;
  }
  public A withSendResolved(Boolean sendResolved) {
    this.sendResolved=sendResolved; return (A) this;
  }
  public Boolean hasSendResolved() {
    return this.sendResolved != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public SecretKeySelector getUrlSecret() {
    return this.urlSecret;
  }
  public A withUrlSecret(SecretKeySelector urlSecret) {
    this.urlSecret=urlSecret; return (A) this;
  }
  public Boolean hasUrlSecret() {
    return this.urlSecret != null;
  }
  public A withNewUrlSecret(String key,String name,Boolean optional) {
    return (A)withUrlSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebhookConfigFluentImpl that = (WebhookConfigFluentImpl) o;
    if (httpConfig != null ? !httpConfig.equals(that.httpConfig) :that.httpConfig != null) return false;
    if (maxAlerts != null ? !maxAlerts.equals(that.maxAlerts) :that.maxAlerts != null) return false;
    if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (urlSecret != null ? !urlSecret.equals(that.urlSecret) :that.urlSecret != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(httpConfig,  maxAlerts,  sendResolved,  url,  urlSecret,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpConfig != null) { sb.append("httpConfig:"); sb.append(httpConfig + ","); }
    if (maxAlerts != null) { sb.append("maxAlerts:"); sb.append(maxAlerts + ","); }
    if (sendResolved != null) { sb.append("sendResolved:"); sb.append(sendResolved + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (urlSecret != null) { sb.append("urlSecret:"); sb.append(urlSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSendResolved() {
    return withSendResolved(true);
  }
  class HttpConfigNestedImpl<N> extends HTTPConfigFluentImpl<WebhookConfigFluent.HttpConfigNested<N>> implements WebhookConfigFluent.HttpConfigNested<N>,Nested<N>{
    HttpConfigNestedImpl(HTTPConfig item) {
      this.builder = new HTTPConfigBuilder(this, item);
    }
    HttpConfigNestedImpl() {
      this.builder = new HTTPConfigBuilder(this);
    }
    HTTPConfigBuilder builder;
    public N and() {
      return (N) WebhookConfigFluentImpl.this.withHttpConfig(builder.build());
    }
    public N endHttpConfig() {
      return and();
    }
    
  }
  
}