package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VictorOpsConfigBuilder extends VictorOpsConfigFluentImpl<VictorOpsConfigBuilder> implements VisitableBuilder<VictorOpsConfig,VictorOpsConfigBuilder>{
  public VictorOpsConfigBuilder() {
    this(false);
  }
  public VictorOpsConfigBuilder(Boolean validationEnabled) {
    this(new VictorOpsConfig(), validationEnabled);
  }
  public VictorOpsConfigBuilder(VictorOpsConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public VictorOpsConfigBuilder(VictorOpsConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VictorOpsConfig(), validationEnabled);
  }
  public VictorOpsConfigBuilder(VictorOpsConfigFluent<?> fluent,VictorOpsConfig instance) {
    this(fluent, instance, false);
  }
  public VictorOpsConfigBuilder(VictorOpsConfigFluent<?> fluent,VictorOpsConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiKey(instance.getApiKey()); 
    fluent.withApiUrl(instance.getApiUrl()); 
    fluent.withCustomFields(instance.getCustomFields()); 
    fluent.withEntityDisplayName(instance.getEntityDisplayName()); 
    fluent.withHttpConfig(instance.getHttpConfig()); 
    fluent.withMessageType(instance.getMessageType()); 
    fluent.withMonitoringTool(instance.getMonitoringTool()); 
    fluent.withRoutingKey(instance.getRoutingKey()); 
    fluent.withSendResolved(instance.getSendResolved()); 
    fluent.withStateMessage(instance.getStateMessage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VictorOpsConfigBuilder(VictorOpsConfig instance) {
    this(instance,false);
  }
  public VictorOpsConfigBuilder(VictorOpsConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiKey(instance.getApiKey()); 
    this.withApiUrl(instance.getApiUrl()); 
    this.withCustomFields(instance.getCustomFields()); 
    this.withEntityDisplayName(instance.getEntityDisplayName()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMessageType(instance.getMessageType()); 
    this.withMonitoringTool(instance.getMonitoringTool()); 
    this.withRoutingKey(instance.getRoutingKey()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withStateMessage(instance.getStateMessage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VictorOpsConfigFluent<?> fluent;
  Boolean validationEnabled;
  public VictorOpsConfig build() {
    VictorOpsConfig buildable = new VictorOpsConfig(fluent.getApiKey(),fluent.getApiUrl(),fluent.getCustomFields(),fluent.getEntityDisplayName(),fluent.getHttpConfig(),fluent.getMessageType(),fluent.getMonitoringTool(),fluent.getRoutingKey(),fluent.getSendResolved(),fluent.getStateMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}