package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SlackFieldBuilder extends SlackFieldFluentImpl<SlackFieldBuilder> implements VisitableBuilder<SlackField,SlackFieldBuilder>{
  public SlackFieldBuilder() {
    this(false);
  }
  public SlackFieldBuilder(Boolean validationEnabled) {
    this(new SlackField(), validationEnabled);
  }
  public SlackFieldBuilder(SlackFieldFluent<?> fluent) {
    this(fluent, false);
  }
  public SlackFieldBuilder(SlackFieldFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SlackField(), validationEnabled);
  }
  public SlackFieldBuilder(SlackFieldFluent<?> fluent,SlackField instance) {
    this(fluent, instance, false);
  }
  public SlackFieldBuilder(SlackFieldFluent<?> fluent,SlackField instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withShort(instance.getShort()); 
    fluent.withTitle(instance.getTitle()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SlackFieldBuilder(SlackField instance) {
    this(instance,false);
  }
  public SlackFieldBuilder(SlackField instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withShort(instance.getShort()); 
    this.withTitle(instance.getTitle()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SlackFieldFluent<?> fluent;
  Boolean validationEnabled;
  public SlackField build() {
    SlackField buildable = new SlackField(fluent.getShort(),fluent.getTitle(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}