package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteBuilder extends RouteFluentImpl<RouteBuilder> implements VisitableBuilder<Route,RouteBuilder>{
  public RouteBuilder() {
    this(false);
  }
  public RouteBuilder(Boolean validationEnabled) {
    this(new Route(), validationEnabled);
  }
  public RouteBuilder(RouteFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteBuilder(RouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Route(), validationEnabled);
  }
  public RouteBuilder(RouteFluent<?> fluent,Route instance) {
    this(fluent, instance, false);
  }
  public RouteBuilder(RouteFluent<?> fluent,Route instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContinue(instance.getContinue()); 
    fluent.withGroupBy(instance.getGroupBy()); 
    fluent.withGroupInterval(instance.getGroupInterval()); 
    fluent.withGroupWait(instance.getGroupWait()); 
    fluent.withMatchers(instance.getMatchers()); 
    fluent.withReceiver(instance.getReceiver()); 
    fluent.withRepeatInterval(instance.getRepeatInterval()); 
    fluent.withRoutes(instance.getRoutes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteBuilder(Route instance) {
    this(instance,false);
  }
  public RouteBuilder(Route instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withContinue(instance.getContinue()); 
    this.withGroupBy(instance.getGroupBy()); 
    this.withGroupInterval(instance.getGroupInterval()); 
    this.withGroupWait(instance.getGroupWait()); 
    this.withMatchers(instance.getMatchers()); 
    this.withReceiver(instance.getReceiver()); 
    this.withRepeatInterval(instance.getRepeatInterval()); 
    this.withRoutes(instance.getRoutes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RouteFluent<?> fluent;
  Boolean validationEnabled;
  public Route build() {
    Route buildable = new Route(fluent.getContinue(),fluent.getGroupBy(),fluent.getGroupInterval(),fluent.getGroupWait(),fluent.getMatchers(),fluent.getReceiver(),fluent.getRepeatInterval(),fluent.getRoutes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}