package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PushoverConfigBuilder extends PushoverConfigFluentImpl<PushoverConfigBuilder> implements VisitableBuilder<PushoverConfig,PushoverConfigBuilder>{
  public PushoverConfigBuilder() {
    this(false);
  }
  public PushoverConfigBuilder(Boolean validationEnabled) {
    this(new PushoverConfig(), validationEnabled);
  }
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PushoverConfig(), validationEnabled);
  }
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent,PushoverConfig instance) {
    this(fluent, instance, false);
  }
  public PushoverConfigBuilder(PushoverConfigFluent<?> fluent,PushoverConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExpire(instance.getExpire()); 
    fluent.withHtml(instance.getHtml()); 
    fluent.withHttpConfig(instance.getHttpConfig()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withRetry(instance.getRetry()); 
    fluent.withSendResolved(instance.getSendResolved()); 
    fluent.withSound(instance.getSound()); 
    fluent.withTitle(instance.getTitle()); 
    fluent.withToken(instance.getToken()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withUrlTitle(instance.getUrlTitle()); 
    fluent.withUserKey(instance.getUserKey()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PushoverConfigBuilder(PushoverConfig instance) {
    this(instance,false);
  }
  public PushoverConfigBuilder(PushoverConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExpire(instance.getExpire()); 
    this.withHtml(instance.getHtml()); 
    this.withHttpConfig(instance.getHttpConfig()); 
    this.withMessage(instance.getMessage()); 
    this.withPriority(instance.getPriority()); 
    this.withRetry(instance.getRetry()); 
    this.withSendResolved(instance.getSendResolved()); 
    this.withSound(instance.getSound()); 
    this.withTitle(instance.getTitle()); 
    this.withToken(instance.getToken()); 
    this.withUrl(instance.getUrl()); 
    this.withUrlTitle(instance.getUrlTitle()); 
    this.withUserKey(instance.getUserKey()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PushoverConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PushoverConfig build() {
    PushoverConfig buildable = new PushoverConfig(fluent.getExpire(),fluent.getHtml(),fluent.getHttpConfig(),fluent.getMessage(),fluent.getPriority(),fluent.getRetry(),fluent.getSendResolved(),fluent.getSound(),fluent.getTitle(),fluent.getToken(),fluent.getUrl(),fluent.getUrlTitle(),fluent.getUserKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}